
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ALTERNATE_MOVE_HASH_H
#define FILE__ALTERNATE_MOVE_HASH_H


#include "Movement.h"


class AlternateMoveHash
{
  protected:
	word32 primaryHash;
	word32 secondaryHash;
	Movement move;


  public:
	//	construction
	AlternateMoveHash()
	{
		move = Movement();
	}

	AlternateMoveHash
		( word32 primary, 
		  word32 secondary, 
		  Movement &movement ):
			primaryHash(primary),
			secondaryHash(secondary),
			move(movement)
	{
	}


	//	attributes
	word32 GetPrimaryHash()
	{	return( primaryHash );   }

	word32 GetSecondaryHash()
	{	return( secondaryHash );   }

	Movement &GetMove()
	{	return( move );   }


	//	friends
	friend class AlternateMoveHashtable;
};


#endif
