
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__HASH_H
#define FILE__HASH_H


#include "Movement.h"


class BestMoveHash
{
  protected:
	word32 hash;
	unsigned int move;
	int depth;
	int age;


  public:
	//	construction
	BestMoveHash()
	{
		primaryHash = 0;
		age = -10;
	}

	Hash
		( word32 hashCode, 
		  unsigned int moveData, 
		  int currentDepth,
		  int currentAge ):
			hash(hashCode),
			move(moveData),
			depth(currentDepth),
			age(currentAge)
	{
	}


	//	attributes
	word32 GetPrimaryHash()
	{	return( hash );   }

	unsigned int GetMoveData()
	{	return( move );   }

	Movement GetMove()
	{	return( new Movement( move ) );   }

	int GetDepth()
	{	return( depth );   }

	int GetAge()
	{	return( age );   }


	//	friends
	friend class Hashtable;
};


#endif
