
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "BitBoard64.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


static const int index64[64] = {
    63,  0, 58,  1, 59, 47, 53,  2,
    60, 39, 48, 27, 54, 33, 42,  3,
    61, 51, 37, 40, 49, 18, 28, 20,
    55, 30, 34, 11, 43, 14, 22,  4,
    62, 57, 46, 52, 38, 26, 32, 41,
    50, 36, 17, 19, 29, 10, 13, 21,
    56, 45, 25, 31, 35, 16,  9, 12,
    44, 24, 15,  8, 23,  7,  6,  5
};


void BitBoard64::InitializeData
	( int nRanks, 
	  int nFiles )
{
}

void BitBoard64::PrintToFile
	( FILE *output_file, 
	  int nRanks, 
	  int nFiles )
{
	for( int rank = nRanks - 1; rank >= 0; rank-- )
	{
		for( int file = 0; file < nFiles; file++ )
		{
			int nBit = rank * nFiles + file;
			if( GetBit( nBit ) )
				fputc( '*', output_file );
			else
				fputc( '.', output_file );
		}
		fprintf( output_file, "  %d\n", rank + 1 );
	}
	fprintf( output_file, "\n" );
	for( int file = 0; file < nFiles; file++ )
		fputc( 'a' + file, output_file );
	fprintf( output_file, "\n\n" );
}
