

/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "BitBoard96.h"


IntVector BitBoard96::bitCount;
IntVector BitBoard96::firstBit;


void BitBoard96::InitializeData
	( int nRanks, 
	  int nFiles )
{
	bitCount.SetSize( 65536 );
	firstBit.SetSize( 65536 );
	for( unsigned u = 0; u < 65536; u++ )
	{
		int bit_count = 0;
		int first_bit = -1;
		for( int x = 0; x < 16; x++ )
		{
			if( u & (1 << x) )
			{
				bit_count++;
				first_bit = x;
			}
		}
		bitCount[u] = bit_count;
		firstBit[u] = first_bit;
	}
}

void BitBoard96::PrintToFile
	( FILE *output_file, 
	  int nRanks, 
	  int nFiles )
{
	for( int rank = nRanks - 1; rank >= 0; rank-- )
	{
		for( int file = 0; file < nFiles; file++ )
		{
			int nBit = rank * nFiles + file;
			if( GetBit( nBit ) )
				fputc( '*', output_file );
			else
				fputc( '.', output_file );
		}
		fprintf( output_file, "  %d\n", rank + 1 );
	}
	fprintf( output_file, "\n" );
	for( int file = 0; file < nFiles; file++ )
		fputc( 'a' + file, output_file );
	fprintf( output_file, "\n\n" );
}
