
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "ChessV.h"
#include "Resource.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


LRESULT CALLBACK CompMoveSelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	char buffer[120];
	LV_COLUMN lvc;
	LVITEM item;
	HWND hList;
	RECT updateRect;
	MovementList &list = theBoard->GetPositionTestList();

	switch( Msg )
	{
	  case WM_INITDIALOG:
		hList = ::GetDlgItem( hWndDlg, IDC_MOVE_LIST );
		memset( &lvc, 0, sizeof(lvc) );
		lvc.pszText = "Move";
		lvc.mask = LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM;
		lvc.cx = 250;
		::SendMessage( hList, LVM_SETEXTENDEDLISTVIEWSTYLE,
           0, LVS_EX_FULLROWSELECT );
		::SendMessage( hList, LVM_INSERTCOLUMN, 0, (LPARAM) &lvc );
		lvc.pszText = "Score";
		lvc.cx = 80;
		::SendMessage( hList, LVM_INSERTCOLUMN, 1, (LPARAM) &lvc );
		memset( &item, 0, sizeof(item) ); 
		item.mask = LVIF_TEXT;
		item.cchTextMax = 256;
		item.iItem = 0;
		item.iSubItem = 0;

		//	add an item for each move
		for( int x = 0; x < list.GetCount(); x++ )
		{
			MoveInfo &move = list.GetOrderedMove( x );
			if( move.evaluation > -100000 )
			{
				theGame->DescribeMove( move, NULL, buffer, NULL );
				item.pszText = buffer;
				item.iItem = x;
				item.iSubItem = 0;
				::SendMessage( hList, LVM_INSERTITEM, 0, (LPARAM) &item );
				item.iSubItem = 1;
				itoa( move.evaluation, buffer, 10 );
				item.pszText = buffer;
				::SendMessage( hList, LVM_SETITEM, 0, (LPARAM) &item );
			}
		}
		return TRUE;

	  case WM_COMMAND:
		switch( wParam )
		{
		  case IDOK:
			testingPosition = false;
			updateRect.top = 0;
			updateRect.left = 0;
			updateRect.right = 680;
			updateRect.bottom = 75;
			::InvalidateRect( theWindow, &updateRect, false );
			::UpdateWindow( theWindow );
			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		}
		break;
	}

	return FALSE;
}
