
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__DIRECTION_H
#define FILE__DIRECTION_H


class Direction
{
  protected:
	//	data members
    int fileDiff;
	int rankDiff;
	int oppositeDirectionNumber;
	Direction *opposite;

  public:
	//	construction
	Direction()  {  }

	Direction
		( int fileChange,
		  int rankChange );

	Direction( const Direction &other );


	//	attributes
	int GetFileDifference()
	{	return( fileDiff );  }

	int GetRankDifference()
	{	return( rankDiff );  }

	Direction &GetOpposite()
	{	return( *opposite );  }

	int GetOppositeDirectionNumber()
	{	return( oppositeDirectionNumber );  }

	Direction &operator!()
	{	return( *opposite );  }

	bool operator==( const Direction &other ) const
	{	return( fileDiff == other.fileDiff && 
	            rankDiff == other.rankDiff );  }

	bool operator==( const MovementCapability &other ) const;

	bool IsAuxilaryDirection() const 
	{	return( fileDiff != 1 && fileDiff != -1 && 
	            rankDiff != 1 && rankDiff != -1 );   }


	//	operations
	Direction &operator=( const Direction &other );

	void SetOppositeDirectionNumber
		( int oppositeDirection );

	void SetOpposite
		( Direction &other );
};


#endif
