
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__DROP_H
#define FILE__DROP_H


class Piece;


class Drop
{
  protected:
	//	data memebers
	Piece *piece;
	int squareNumber;
	PieceType *swapType;

  public:
	//	construction
	Drop()
	{	}

	Drop( Drop const &other ):
		piece(other.piece), 
		squareNumber(other.squareNumber),
		swapType(other.swapType)
	{	}

	Drop( Piece *pieceToDrop, int targetSquareNumber, PieceType *newType = NULL ):
		piece(pieceToDrop),
		squareNumber(targetSquareNumber),
		swapType(newType)
	{	}


	//	assignment
	Drop &operator=( Drop const &other )
	{
		piece = other.piece;
		squareNumber = other.squareNumber;
		swapType = other.swapType;

		return *this;
	}


	//	member access
	Piece *GetPiece()
	{	return piece;   }

	int GetSquareNumber()
	{	return squareNumber;   }

	PieceType *GetSwapType()
	{	return swapType;   }

	void SetSwapType( PieceType *otherType )
	{	swapType = otherType;   }

	void ClearOtherType()
	{	swapType = NULL;   }
};


#endif
