
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__FLOAT_VECTOR
#define FILE__FLOAT_VECTOR


#include <fvec.h>


class FloatVector
{
  protected:
	F32vec4 *vector;
	int vectorSize;
	int numberOfvec4s;

  public:
	FloatVector()
	{
		vector = NULL;
		vectorSize = 0;
		numberOfvec4s = 0;
	}

	~FloatVector()
	{
		if( vector != NULL )
			delete[] vector;
	}

	FloatVector( int size )
	{
		vectorSize = size + (size % 4 ? 4 - (size % 4) : 0);
		numberOfvec4s = vectorSize / 4;
		vector = new F32vec4[numberOfvec4s];
		
		for( int i = 0; i < numberOfvec4s; i++ )
		{
			vector[i][0] = (float) 0.0;
			vector[i][1] = (float) 0.0;
			vector[i][2] = (float) 0.0;
			vector[i][3] = (float) 0.0;
		}
	}

	void SetSize( int size )
	{
		vectorSize = size + (size % 4 ? 4 - (size % 4) : 0);
		numberOfvec4s = vectorSize / 4;
		vector = new F32vec4[numberOfvec4s];
		
		for( int i = 0; i < numberOfvec4s; i++ )
		{
			vector[i][0] = (float) 0.0;
			vector[i][1] = (float) 0.0;
			vector[i][2] = (float) 0.0;
			vector[i][3] = (float) 0.0;
		}
	}

	float &operator[]( int index )
	{
		return( vector[index / 4][index % 4] ); 
	}

	FloatVector &operator+=( FloatVector &other )
	{
		for( int i = 0; i < numberOfvec4s; i++ )
		{
			for( int j = 0; j < 4; j++ )
			{
				vector[i][j] += other.vector[i][j];
			}
		}
		return( *this );
	}

	FloatVector &operator-=( FloatVector &other )
	{
		for( int i = 0; i < numberOfvec4s; i++ )
			for( int j = 0; j < 4; j++ )
			{
				vector[i][j] -= other.vector[i][j];
			}
		return( *this );
	}
};


#endif
