
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

#include "StdAfx.h"
#include "GDIObject.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


GDIObject::GDIObject():
		handle(NULL),
		destroyHandle(false)
{
}

GDIObject::GDIObject
	( GDIObject const &other ):
		handle(other.handle),
		destroyHandle(false)
{
}

GDIObject::GDIObject
	( HGDIOBJ hObject, 
	  bool destroyObject ):
		handle(hObject),
		destroyHandle(destroyObject)
{
}

GDIObject::~GDIObject()
{
	if( destroyHandle )
		DestroyObject();
}

GDIObject::operator HGDIOBJ() const
{
	return this == NULL ? NULL : handle;
}

HGDIOBJ GDIObject::GetSafeHandle() const
{
	return this == NULL ? NULL : handle;
}

void GDIObject::DestroyObject()
{
	if( handle != NULL )
	{
		BOOL returnVal = ::DeleteObject( handle );
		ASSERT(returnVal != 0);
	}
}
