
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "GameParameters.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


//	storage for game paramteters
int nGameParameters = 0;
GameParameter *gameParameters = NULL;


// *** LOOKING UP PARAMETER VALUES *** //

bool LookupIntParameter
	( char *paramName,
	  int &value )
{
	for( int x = 0; x < nGameParameters; x++ )
		if( !strcmp( paramName, gameParameters[x].parameterName ) )
		{
			value = gameParameters[x].parameterValue.intValue;
			return true;
		}
	return false;
}

bool LookupBoolParameter
	( char *paramName, 
	  bool &value )
{
	for( int x = 0; x < nGameParameters; x++ )
		if( !strcmp( paramName, gameParameters[x].parameterName ) )
		{
			value = gameParameters[x].parameterValue.boolValue;
			return true;
		}
	return false;
}

bool LookupStringParameter
	( char *paramName, 
	  char *&value )
{
	for( int x = 0; x < nGameParameters; x++ )
		if( !strcmp( paramName, gameParameters[x].parameterName ) )
		{
			value = gameParameters[x].parameterValue.pCharValue;
			return true;
		}
	return false;
}


// *** STORING PARAMETERS *** //

void StoreParameter
	( char *paramName, 
	  int value )
{
	//	check to see if this parameter already has a value
	for( int x = 0; x < nGameParameters; x++ )
		if( !strcmp( paramName, gameParameters[x].parameterName ) )
		{
			gameParameters[x].parameterValue.intValue = value;
			gameParameters[x].type = int_Parameter;
			return;
		}

	//	it does not already exist, so create a new entry
	char *name = new char[strlen(paramName) + 1];
	strcpy( name, paramName );
	gameParameters[nGameParameters].parameterName = name;
	gameParameters[nGameParameters].parameterValue.intValue = value;
	gameParameters[nGameParameters].type = int_Parameter;
	nGameParameters++;
}

void StoreParameter
	( char *paramName, 
	  bool value )
{
	//	check to see if this parameter already has a value
	for( int x = 0; x < nGameParameters; x++ )
		if( !strcmp( paramName, gameParameters[x].parameterName ) )
		{
			gameParameters[x].parameterValue.boolValue = value;
			gameParameters[x].type = bool_Parameter;
			return;
		}

	//	it does not already exist, so create a new entry
	char *name = new char[strlen(paramName) + 1];
	strcpy( name, paramName );
	gameParameters[nGameParameters].parameterName = name;
	gameParameters[nGameParameters].parameterValue.boolValue = value;
	gameParameters[nGameParameters].type = bool_Parameter;
	nGameParameters++;
}

void StoreParameter
	( char *paramName,
	  char *value )
{
	//	check to see if this parameter already has a value
	for( int x = 0; x < nGameParameters; x++ )
		if( !strcmp( paramName, gameParameters[x].parameterName ) )
		{
			delete[] gameParameters[x].parameterValue.pCharValue;
			gameParameters[x].parameterValue.pCharValue = new char[strlen(value) + 2];
			strcpy( gameParameters[x].parameterValue.pCharValue, value );
			gameParameters[x].type = string_Parameter;
			return;
		}

	//	it does not already exist, so create a new entry
	char *name = new char[strlen(paramName) + 1];
	strcpy( name, paramName );
	gameParameters[nGameParameters].parameterName = name;
	gameParameters[nGameParameters].parameterValue.pCharValue = 
		new char[strlen(value) + 2];
	gameParameters[nGameParameters].type = string_Parameter;
	strcpy( gameParameters[nGameParameters].parameterValue.pCharValue, value );
	nGameParameters++;
}


// *** CLEAN-UP *** //

void CleanupGameParameters()
{
	for( int x = 0; x < nGameParameters; x++ )
	{
		delete[] gameParameters[x].parameterName;
		if( gameParameters[x].type == string_Parameter )
			delete[] gameParameters[x].parameterValue.pCharValue;
	}
}
