
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__GAME_PARAMETERS_H
#define FILE__GAME_PARAMETERS_H


enum ParameterType
{
	int_Parameter = 1,
	bool_Parameter = 2,
	string_Parameter = 3
};

struct GameParameter
{
	char *parameterName;
	ParameterType type;
	union
	{
		int intValue;
		bool boolValue;
		char *pCharValue;
	} parameterValue;
};


//	storage for game paramteters
extern int nGameParameters;
extern GameParameter *gameParameters;


//	lookup up the value of parameters
bool LookupIntParameter( char *paramName, int &value );
bool LookupBoolParameter( char *paramName, bool &value );
bool LookupStringParameter( char *paramName, char *&value );


//	adding new parameters
void StoreParameter( char *paramName, int value );
void StoreParameter( char *paramName, bool value );
void StoreParameter( char *paramName, char *value );


//	clean-up
void CleanupGameParameters();


#endif
