
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "ChessV.h"
#include "Resource.h"


LRESULT CALLBACK GameSelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	switch( Msg )
	{
	  case WM_INITDIALOG:
		::SendDlgItemMessage( hWndDlg, IDC_LOS_ALAMOS_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
		::SendDlgItemMessage( hWndDlg, IDC_CHESS_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		return TRUE;

	  case WM_COMMAND:
		switch( wParam )
		{
		  case IDOK:
			if( ::SendDlgItemMessage( hWndDlg, IDC_LOS_ALAMOS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Los Alamos Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Orthodox Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CWDA_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Chess with Different Armies" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CWAK_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Chess with Augmented Knights" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_EXTINCTION_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Extinction Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_BEROLINA_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Berolina Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_KINGLET_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Kinglet Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_THREE_CHECKS_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Three Checks Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CAPABLANCA_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Capablanca Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ALAPO_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Alapo" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CYLINDRICAL_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Cylindrical Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SHATRANJ_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Shatranj" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_COURIER_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Courier Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ARCHCHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Archchess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ODINS_RUNE_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Odin's Rune Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CITADEL_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Citadel Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_POLYMORPH_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Polymorph Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_UNICORN_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Unicorn Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CARRERA_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Carrera's Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_GRAND_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Grand Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_JANUS_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Janus Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_LIONS_AND_UNICORNS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Lions and Unicorns Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ANGELS_AND_DEVILS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Angels and Devils" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SWITCHING_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Switching Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CHESS_WITH_ULTIMA_PIECES_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Chess with Ultima Pieces" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ULTIMA_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Ultima" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_GROTESQUE_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Grotesque Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_OPULENT_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Opulent Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_TENCUBED_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "TenCubed Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_MODERN_SHATRANJ_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Modern Shatranj" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SHATRANJ_KAMIL_64_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Shatranj Kamil (64)" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_EURASIAN_CHESS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Eurasian Chess" );
			::EndDialog( hWndDlg, 0 );
			return TRUE;

		  case IDCANCEL:
			::EndDialog( hWndDlg, IDCANCEL );
			return TRUE;

		  case ID_LOAD_SAVED_GAME:
			::EndDialog( hWndDlg, ID_LOAD_SAVED_GAME );
			break;

		  case IDC_BUTTON1:
			int rtn = (int) ::DialogBox( theInstance, MAKEINTRESOURCE(IDD_NEW_GAME_DIALOG), NULL, 
				reinterpret_cast<DLGPROC>(NewGameSelectDlgProc) );
			
		}
		break;
	}

	return FALSE;
}
