
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__HASH_H
#define FILE__HASH_H


#include "Movement.h"


enum HashType
{
	NoHash = 0,
	Exact = 1,
	UpperBound = 2,
	LowerBound = 3,
	Quiescent = 4,
	PoorDraft = 5
};

class Hash
{
  protected:
	word32 primaryHash;
	word32 secondaryHash;
	int depth;
	int score;
	Movement move;
	HashType type;
	int age;


  public:
	//	construction
	Hash()
	{
		type = NoHash;
		primaryHash = (word32) 0;
		secondaryHash = (word32) 0;
		depth = 0;
		score = 0;
		age = 0;
	}

	Hash
		( word32 primary, 
		  word32 secondary, 
		  int currentDepth,
		  int currentScore,
		  Movement &movement,
		  HashType hashType ):
			primaryHash(primary),
			secondaryHash(secondary),
			depth(currentDepth),
			score(currentScore),
			move(movement),
			type(hashType)
	{
	}


	//	attributes
	word32 GetPrimaryHash()
	{	return( primaryHash );   }

	word32 GetSecondaryHash()
	{	return( secondaryHash );   }

	int GetDepth()
	{	return( depth );   }

	int GetScore()
	{	return( score );   }

	Movement &GetMove()
	{	return( move );   }

	HashType GetType()
	{	return( type );   }


	//	friends
	friend class Hashtable;
};


#endif
