
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__HASH_MAP
#define FILE__HASH_MAP


#include "rand.h"


class HashMap
{
  protected:
	//	data members
	int nSquares;
	word32 *hashes;

  public:
	//	construction
	HashMap()
	{
		nSquares = -1;
		hashes = NULL;
	}

	HashMap( int numberOfSquares )
	{
		nSquares = numberOfSquares;
		hashes = new word32[nSquares];
		for( int i = 0; i < numberOfSquares; i++ )
			hashes[i] = rand_32();
	}

	~HashMap()
	{
		if( hashes != NULL )
			delete[] hashes;
	}

	void Initialize( int numberOfSquares )
	{
		nSquares = numberOfSquares;
		hashes = new word32[nSquares];
		for( int i = 0; i < numberOfSquares; i++ )
		{
			hashes[i] = rand_32();
		}
	}

	//	attributes
	word32 GetHash( int squareNumber )
	{
		return( hashes[squareNumber] );
	}
};


#endif
