
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__HISTORICAL_MOVE_H
#define FILE__HISTORICAL_MOVE_H


#include "MoveInfo.h"


class HistoricalMove
{
  protected:
	MoveType moveType;
	Piece *pPieceMoved;
	int fromSquare;
	int toSquare;

  public:
	//	construction
	HistoricalMove():
		moveType(NullMove),
		fromSquare(0),
		toSquare(0),
		pPieceMoved(NULL)
	{
	}

	HistoricalMove( const MoveInfo &moveInfo );

	HistoricalMove( MoveType movementType, int from, int to, Piece *pieceMoved ):
		fromSquare(from),
		toSquare(to),
		moveType(movementType),
		pPieceMoved(pieceMoved)
	{
	}


	//	attributes
	int GetFromSquare() const
	{	return( fromSquare );  }

	int GetToSquare() const
	{	return( toSquare );  }

	bool IsNullMove() const
	{	return moveType == NullMove;  }

	Piece *GetPieceMoved() const
	{	return pPieceMoved;   }

	MoveType GetMovementType() const 
	{	return moveType;   }


	//	assignment
	HistoricalMove &operator=( HistoricalMove const &other )
	{
		fromSquare = other.fromSquare;
		toSquare = other.toSquare;
		moveType = other.moveType;
		pPieceMoved = other.pPieceMoved;
		return( *this );
	}
};


#endif
