
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "ChessV.h"
#include "Resource.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


MoveInfo **allowableMoves;
int *allowableMoveIndexes;
int allowableMoveCount;


LRESULT CALLBACK MoveSelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	int x;
	int nItem;
	int moveNumber;
	char buffer[120];
	switch( Msg )
	{
	  case WM_INITDIALOG:
		for( x = 0; x < allowableMoveCount; x++ )
		{
			theGame->DescribeMove( *(allowableMoves[x]), buffer, NULL, NULL );
			::SendDlgItemMessage( hWndDlg, IDC_MOVE_LIST, LB_ADDSTRING, 0, (LPARAM) buffer );
			::SendDlgItemMessage( hWndDlg, IDC_MOVE_LIST, LB_SETITEMDATA, x, (LPARAM) allowableMoveIndexes[x] );
		}
		return TRUE;

	  case WM_COMMAND:
		switch( wParam )
		{
		  case IDOK:
			nItem = (int) ::SendDlgItemMessage( hWndDlg, IDC_MOVE_LIST, LB_GETCURSEL, 0, 0 );
			moveNumber = (int) ::SendDlgItemMessage( hWndDlg, IDC_MOVE_LIST, LB_GETITEMDATA, nItem, 0 );
			::EndDialog( hWndDlg, moveNumber );
			return TRUE;

		  case IDCANCEL:
			::EndDialog( hWndDlg, -1 );
			return TRUE;

		  case ID_LOAD_SAVED_GAME:
			::EndDialog( hWndDlg, ID_LOAD_SAVED_GAME );
			break;

		  default:
			if( HIWORD(wParam) == LBN_DBLCLK )
			{
				nItem = (int) ::SendDlgItemMessage( hWndDlg, IDC_MOVE_LIST, LB_GETCURSEL, 0, 0 );
				moveNumber = (int) ::SendDlgItemMessage( hWndDlg, IDC_MOVE_LIST, LB_GETITEMDATA, nItem, 0 );
				::EndDialog( hWndDlg, moveNumber );
				return TRUE;
			}
		}
		break;
	}

	return FALSE;
}
