
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "Direction.h"
#include "MovementCapability.h"
#include "Board.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


//	construction
MovementCapability::MovementCapability()
{
}

MovementCapability::MovementCapability
	( int fileChange, 
	  int rankChange,
	  int steps )
{
	fileDiff = fileChange;
	rankDiff = rankChange;
	maxSteps = steps;
	minSteps = 1;
	type = Normal;
	withdrawingCaptures = false;
	advancingCaptures = false;
	directionNumber = -1;
	for( int x = 0; x < MAX_SQUARES; x++ )
		restrictionZone.AddToZone( x );
}

MovementCapability::MovementCapability
	( int fileChange, 
	  int rankChange,
	  int steps,
	  MovementType moveType )
{
	fileDiff = fileChange;
	rankDiff = rankChange;
	maxSteps = steps;
	minSteps = 1;
	type = moveType;
	withdrawingCaptures = false;
	advancingCaptures = false;
	directionNumber = -1;
	for( int x = 0; x < MAX_SQUARES; x++ )
		restrictionZone.AddToZone( x );
}

MovementCapability::MovementCapability
	( int fileChange, 
	  int rankChange,
	  int steps,
	  MovementType moveType,
	  int minSquareNumber, 
	  int maxSquareNumber, 
	  bool withdrawCapture, 
	  bool advanceCapture,
	  int minimumSteps )
{
	fileDiff = fileChange;
	rankDiff = rankChange;
	maxSteps = steps;
	minSteps = minimumSteps;
	type = moveType;
	withdrawingCaptures = withdrawCapture;
	advancingCaptures = advanceCapture;
	directionNumber = -1;
	for( int x = minSquareNumber; x <= maxSquareNumber; x++ )
		restrictionZone.AddToZone( x );
}

MovementCapability::MovementCapability
	( MovementCapability const &other )
{
	fileDiff = other.fileDiff;
	rankDiff = other.rankDiff;
	maxSteps = other.maxSteps;
	minSteps = other.minSteps;
	type = other.type;
	withdrawingCaptures = other.withdrawingCaptures;
	advancingCaptures = other.advancingCaptures;
	directionNumber = other.directionNumber;
	restrictionZone = other.restrictionZone;
}


//	assignment
MovementCapability &MovementCapability::operator=
	( MovementCapability const &other )
{
	fileDiff = other.fileDiff;
	rankDiff = other.rankDiff;
	maxSteps = other.maxSteps;
	minSteps = other.minSteps;
	type = other.type;
	withdrawingCaptures = other.withdrawingCaptures;
	advancingCaptures = other.advancingCaptures;
	directionNumber = other.directionNumber;
	restrictionZone = other.restrictionZone;

	return( *this );
}


//	attributes
int MovementCapability::GetFileDifference( const Player &player ) const
{
	if( player.GetPlayerNumber() == 1 )
		return( -fileDiff );
	return( fileDiff );
}

int MovementCapability::GetFileDifference( int playerNumber ) const
{
	if( playerNumber == 1 )
		return( -fileDiff );
	return( fileDiff );
}

int MovementCapability::GetRankDifference( const Player &player ) const
{
	if( player.GetPlayerNumber() == 1 )
		return( -rankDiff );
	return( rankDiff );
}

int MovementCapability::GetRankDifference( int playerNumber ) const
{
	if( playerNumber == 1 )
		return( -rankDiff );
	return( rankDiff );
}
