
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__PAWN_HASH_H
#define FILE__PAWN_HASH_H


enum PawnHashType
{
	InvalidHash = 0,
	ValidHash = 1
};

class PawnHash
{
  protected:
	// *** DATA MEMBERS *** //

	word32 primaryHash;
	//	primary pawn hash identifying this position 

	word32 secondaryHash;
	//	secondary pawn hash identifying this position 

	PawnHashType hashType;
	//	type of hash; either InvalidHash or ValidHash

	int score;
	//	evaluation score of this position

  public:
	char nPawnsPerFile[2][12];
	char backPawnRank[2][12];


	//	construction
	PawnHash()
	{	hashType = InvalidHash;  }

	PawnHash
		( word32 primary, 
		  word32 secondary, 
		  int scoreAdjustment ):
			primaryHash(primary),
			secondaryHash(secondary),
			score(scoreAdjustment),
			hashType(ValidHash)
	{	}


	//	attributes
	word32 GetPrimaryHash()
	{	return primaryHash;   }

	word32 GetSecondaryHash()
	{	return secondaryHash;   }

	bool IsValid()
	{	return hashType != InvalidHash;   }

	int GetScore()
	{	return score;   }


	//	friends
	friend class PawnHashtable;
};


#endif
