
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__PAWN_HASHTABLE_H
#define FILE__PAWN_HASHTABLE_H


#include "PawnHash.h"


class PawnHashtable
{
  protected:
	//	data memebers
	Board &board;
	PawnHash *table;
	int tableSize;
	word32 hashMask;

	//	helper functions
	int EvaluatePawnStructure( PawnHash *pHash );


  public:
	//	construction
	PawnHashtable( Board &theBoard, unsigned sizeInMB = 16 );

	
	// *** OPERATIONS *** //

	int Lookup( PawnHash **ppPawnHashOut );
	//	lookup current pawn structure in the hashtable...  if it does not 
	//	exist in the table, then calculate it and add it to the table. 
	//	this function returns the evaluation of the current pawn structure.
};


#endif
