
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__PIECE_SQUARE_INFO
#define FILE__PIECE_SQUARE_INFO


class PieceSquareInfo
{
  protected:
	//	member variables
	int nDirectionsAttacked;
	int nSafeChecks;
	float fSquaresAttacked;
	float fCenterSquaresAttacked;
	float value;
	bool found;


  public:
	//	construction
	PieceSquareInfo():
		nDirectionsAttacked(0),
		fSquaresAttacked(0.0),
		fCenterSquaresAttacked(0.0),
		nSafeChecks(0),
		value(0.0),
		found(false)
	{
	}


	//	attributes
	int GetDirectionsAttacked()
	{
		return( nDirectionsAttacked );
	}

	int GetSafeChecks()
	{
		return( nSafeChecks );
	}

	float GetSquaresAttacked()
	{
		return( fSquaresAttacked );
	}

	float GetCenterSquaresAttacked()
	{
		return( fCenterSquaresAttacked );
	}


	//	friends
	friend class PieceType;
};


#endif
