
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__PLAYER_H
#define FILE__PLAYER_H


#define MAX_PIECE_COUNT    1000


class Player
{
  protected:
	//	data members
	char *name;
	int number;
	bool computer;
	float material;


  public:
	//	construction
	Player( char *color, int playerNumber, bool computerPlayer )
	{
		number = playerNumber;
		computer = computerPlayer;
		int colorLength = (int) strlen(color) + 1;
		name = new char[colorLength];
		strcpy( name, color );
	}

	virtual ~Player()
	{
		delete[] name;
	}


	//	attributes
	int GetPlayerNumber() const
	{	return number;   }

	bool IsComputerControlled() const
	{	return computer;   }

	char *GetName() const
	{	return name;   }


	//	operations
	void SetComputerControl( bool isComputerControlled )
	{	computer = isComputerControlled;   }
};


#endif
