
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "ChessV.h"
#include "Resource.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


LRESULT CALLBACK PositionTestingDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	switch( Msg )
	{
	  case WM_INITDIALOG:
		char buffer[20];
		itoa( testingDepth, buffer, 10 );
		::SendDlgItemMessage( hWndDlg, IDC_TESTING_IDEPTH_EDIT, WM_SETTEXT, (WPARAM) 0, (LPARAM) buffer );
		itoa( testingMaxMoves, buffer, 10 );
		::SendDlgItemMessage( hWndDlg, IDC_TESTING_MAX_MOVES_EDIT, WM_SETTEXT, (WPARAM) 0, (LPARAM) buffer );
		return TRUE;

	  case WM_COMMAND:
		switch( wParam )
		{
		  case IDOK:
			char buffer[20];
			::SendDlgItemMessage( hWndDlg, IDC_TESTING_IDEPTH_EDIT, WM_GETTEXT, (WPARAM) 18, (LPARAM) buffer );
			testingDepth = atoi( buffer );
			::SendDlgItemMessage( hWndDlg, IDC_TESTING_MAX_MOVES_EDIT, WM_GETTEXT, (WPARAM) 18, (LPARAM) buffer );
			testingMaxMoves = atoi( buffer );
			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		}
		break;
	}

	return FALSE;
}
