
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__PROMOTION_H
#define FILE__PROMOTION_H


enum PromotionCapability
{
	NoPromotion = 0,
	PromoteToSpecificType = 1,
	PromoteToVariableTypes = 2,
	PromoteByReplacement = 3,
	PromoteByReplacementOrToVariableTypes = 4
};


class Promotion
{
  protected:
	PromotionCapability capability;
	PieceType *typeToPromoteTo;

  public:
	//	construction
	Promotion()
	{	capability = NoPromotion;   }

	Promotion( const Promotion &other )
	{	capability = other.capability;
		typeToPromoteTo = other.typeToPromoteTo;   }


	//	attributes
	PromotionCapability GetPromotionCapability()
	{	return capability;   }

	PieceType &GetTypeToPromoteTo()
	{	return *typeToPromoteTo;  }


	//	operations
	void Clear()
	{	capability = NoPromotion;   }

	Promotion &operator=( const Promotion &other )
	{	capability = other.capability;
		typeToPromoteTo = other.typeToPromoteTo;  
		return *this;   }

	void SetPromotionCapability( PromotionCapability promotionCapability )
	{	capability = promotionCapability;   }

	void SetTypeToPromoteTo( PieceType &type )
	{	typeToPromoteTo = &type;   }
};


#endif
