
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__STATISTICS_H
#define FILE__STATISTICS_H


#ifndef MAX_PERFORMANCE
#define STAT_INCREMENT(statistic)                                        \
	(Statistics::##statistic)++;
#define STAT_LOOKUP(statistic)                                           \
	(Statistics::##statistic)
#else
#define STAT_INCREMENT(statistic)   ;
#define STAT_LOOKUP(statistic)		0
#endif


class Statistics
	/*	this class is never instanciated.  it's static fields store 
		various statistics that are tracked during the move search.  */
{
  public:
	//	node counts
	static __int64 nodeCount;
	static __int64 qnodeCount;

	//	transposition table stats
	static __int64 ttLookupCount;
	static __int64 ttLookupMatchCount;
	static __int64 ttExactCount;
	static __int64 ttLowerBoundCount;
	static __int64 ttUpperBoundCount;

	//	pawn hashtable stats
	static __int64 phtLookupCount;
	static __int64 phtMatchCount;

	//	evaluation cache stats
	static __int64 ecLookupCount;
	static __int64 ecMatchCount;

	//	search extensions
	static __int64 checkExtensions;
	static __int64 recaptureExtensions;
	static __int64 singularExtensions;
	static __int64 mateThreatExtensions;

	//	forward pruning
	static __int64 nullCutoffs;
	static __int64 nodesPruned;
	static __int64 nodesRazored;

	//	PV accuracy
	static __int64 pvNodeEncountered;
	static __int64 pvNodeFirstMoveCorrect;


	// *** OPERATIONS *** //
	static void ResetStats()
	{
		nodeCount = (__int64) 0LL;
		qnodeCount = (__int64) 0LL;
		ttLookupCount = (__int64) 0LL;
		ttLookupMatchCount = (__int64) 0LL;
		ttExactCount = (__int64) 0LL;
		ttLowerBoundCount = (__int64) 0LL;
		ttUpperBoundCount = (__int64) 0LL;
		phtLookupCount = (__int64) 0LL;
		phtMatchCount = (__int64) 0LL;
		ecLookupCount = (__int64) 0LL;
		ecMatchCount = (__int64) 0LL;
		nullCutoffs = (__int64) 0LL;
		nodesPruned = (__int64) 0LL;
		nodesRazored = (__int64) 0LL;
		checkExtensions = (__int64) 0LL;
		recaptureExtensions = (__int64) 0LL;
		singularExtensions = (__int64) 0LL;
		mateThreatExtensions = (__int64) 0LL;
	}
};


#endif
