
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__STRUCTURE_VECTOR_H
#define FILE__STRUCTURE_VECTOR_H


template<class Type>
class StructureVector
{
  protected:
	Type *vector;
	unsigned vectorSize;

  public:
	StructureVector<Type>()
	{
		vector = NULL;
		vectorSize = 0U;
	}

	StructureVector<Type>( unsigned size )
	{
		vector = new Type *[size];
		vectorSize = size;
		for( unsigned i = 0; i < size; i++ )
			vector[i] = 0;
	}

	~StructureVector<Type>()
	{
		if( vector != NULL )
			delete[] vector;
	}

	void Free()
	{
		if( vector != NULL )
			delete[] vector;
		vector = NULL;
		vectorSize = 0U;
	}

	void SetSize( unsigned size )
	{
		#ifdef _DEBUG
		ASSERT(vector == NULL);
		#endif

		vector = new Type[size];
		vectorSize = size;
	}

	Type GetElement( unsigned index ) const
	{
		#ifdef _DEBUG
		ASSERT(index < vectorSize);
		#endif

		return( vector[index] ); 
	}

	Type &operator[]( unsigned index )
	{
		#ifdef _DEBUG
		ASSERT(index < vectorSize);
		#endif

		return( vector[index] ); 
	}

	StructureVector<Type> &operator+=( Vector<Type> &other )
	{
		#ifdef _DEBUG
		ASSERT(vectorSize == other.vectorSize);
		#endif

		for( unsigned i = 0; i < vectorSize; i++ )
			vector[i] += other[i];
		return( *this );
	}

	StructureVector<Type> &operator-=( Vector<Type> &other )
	{
		#ifdef _DEBUG
		ASSERT(vectorSize == other.vectorSize);
		#endif

		for( unsigned i = 0; i < vectorSize; i++ )
			vector[i] -= other[i];
		return( *this );
	}
};


#endif
