
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2006 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__WIN_UTIL_H
#define FILE__WIN_UTIL_H


// *** BASIC DATA TYPES *** //
typedef unsigned char byte;
typedef unsigned int word32;


// *** PREPROCESSOR MACROS *** //
#define ROUND_TO_POWER_OF_TWO(x, resolution) ((x + resolution - 1) & ~(resolution - 1))


// *** CONSTANTS *** //
const int noMansLandSize = 12;


// *** STRUCTURES *** //
struct SMemoryAllocationInfo
{
	struct SMemoryAllocationInfo *pPrevious;
	struct SMemoryAllocationInfo *pNext;
	char *filename;
	int nLine;
	size_t size;
	byte noMansLand[noMansLandSize];
};


// *** GLOBALS *** //
extern SMemoryAllocationInfo *pFirstMemoryAllocation;


// *** FUNCTIONS *** //
void *safe_malloc
	( size_t allocationSize,
	  char *filename,
	  int nLine );


#endif
