
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ZONE_H
#define FILE__ZONE_H


class Zone
{
  protected:
	int inZone[MAX_SQUARES];

  public:
	//	construction
	Zone();

	Zone( int startSquareNumber, int endSquareNumber );


	//	attributes
	bool IsInZone( int squareNumber )
	{
		return inZone[squareNumber] != 0;
	}


	//	operations
	void AddToZone( int squareNumber )
	{
		inZone[squareNumber] = 1;
	}

	void AddToZone( int startSquareNumber, int endSquareNumber )
	{
		for( int square = startSquareNumber; square <= endSquareNumber; square++ )
			inZone[square] = 1;
	}

	Zone &operator=( const Zone &other )
	{
		for( int x = 0; x < MAX_SQUARES; x++ )
			inZone[x] = other.inZone[x];
		return *this;
	}
};


#endif
