
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__BOARD_WITH_HANGING_SQUARES_H
#define FILE__BOARD_WITH_HANGING_SQUARES_H


#include "../Board.h"


#define MAX_HANGING_SQUARES		50


struct HangingSquare
{
	int rank;
	int file;
};


//	The BoardWithHangingSquares class is for (mostly) rectangular boards with 
//	extra ("hanging") squares around the edge, such as in Omega Chess.
//
class BoardWithHangingSquares:
	public Board
{
  protected:
	HangingSquare *pHangingSquares;
	int nHangingSquares;


  public:
	//	construction and setup
	BoardWithHangingSquares( int ranks, int files );

	virtual ~BoardWithHangingSquares();

	virtual void AddHangingSquare( int rank, int file );

	virtual void DrawBoard( HWND hwnd, HDC hdc, LPPAINTSTRUCT ps );
};


#endif
