
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../ChessV.h"
#include "../GUI/Brush.h"
#include "DecimalBoardWithRiver.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


DecimalBoardWithRiver::DecimalBoardWithRiver():
	DecimalBoard()
{
	gameSpecificBoardDisplayDescription = "Show River";
}

void DecimalBoardWithRiver::DrawBoard
	( HWND hwnd, 
	  HDC hdc, 
	  LPPAINTSTRUCT ps )
{
	DecimalBoard::DrawBoard( hwnd, hdc, ps );

	//	draw the river
	if( gameSpecificBoardDisplay )
	{
		int topMargin    = 75;
		int leftMargin   = 20;
		if( theBoard->GetNumberOfFiles() < 8 )
			leftMargin += 54;

		RECT rect;
		rect.left = leftMargin + borderWidth;
		rect.top = topMargin + borderWidth + 5 * squareHeight - 6;
		rect.right = leftMargin + borderWidth + 10 * squareWidth + 1;
		rect.bottom = rect.top + 12;

		Brush riverBrush( RGB(0, 90, 200) );
		::SelectObject( hdc, ::GetStockObject( NULL_PEN ) );
		::SelectObject( hdc, riverBrush );
		::Rectangle( hdc, rect.left, rect.top, rect.right, rect.bottom );
	}
}
