
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ARCHCHESS_GAME_H
#define FILE__ARCHCHESS_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"
#include "Decimal_Types.h"


//	***************************
//	**                       **
//	**     ArchchessGame     **
//	**                       **
//	***************************
//
//	the ArchchessGame class overrides the Game class to provide all the 
//	extra capabilities needed to play the games provided by this class. 
//	


class ArchchessGame:
	public Game
{
  protected:
	//	data members
	Piece *queens[2];
	Piece *rooks[2][SET_SIZE];
	Piece *minorPieces[2][SET_SIZE];
	
	HashMap *enPassantHashMap;
	//	Zobrist keys which are x-or'ed into the board's primary hash
	//	for the current "en passant" square, if any


	//	helper functions
	void InitializeBoard();

	// *** OVERRIDES *** //
	virtual void AddPlayerPieceTypes();


  public:
	//	construction
	ArchchessGame( Board &board, Player &whitePlayer, Player &blackPlayer );


	// *** OVERRIDES *** //
	virtual PieceType **GetPieceTypesRequired
		( int &nPieceTypes );

	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord,
		  bool quiescentSearch );

	virtual word32 AdjustPrimaryHash
		( word32 primaryHash );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  PieceType **promotions );

	virtual Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual void DeletePiece
		( Piece *piece );

	virtual void DefaultSettings();
};


#endif
