
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../Resource.h"
#include "../../GameParameters.h"
#include "../ChessGames/ChessGame.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


static HWND hSubDialog;


LRESULT CALLBACK CWUP_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	char buffer[20];

	switch( Msg )
	{
	  case WM_INITDIALOG:
		{
			//	create the computer settings sub-dialog
			HRSRC hrsrc = FindResource( NULL, MAKEINTRESOURCE(IDD_COMPUTER_SETTINGS_EMBEDDED_DIALOG), RT_DIALOG ); 
			HGLOBAL hglb = LoadResource( theInstance, hrsrc ); 
			hSubDialog = ::CreateDialogIndirect( theInstance, (DLGTEMPLATE *) LockResource( hglb ), 
				hWndDlg, reinterpret_cast<DLGPROC>(Generic_SelectSubDlgProc) ); 
			HWND hStaticPlacementItem = ::GetDlgItem( hWndDlg, IDC_COMPUTER_SETTINGS_STATIC );
			RECT childRect;
			::GetWindowRect( hStaticPlacementItem, &childRect );
			POINT point;
			point.x = 0;
			point.y = 0;
			::ClientToScreen( hWndDlg, &point );
			::MoveWindow( hSubDialog, childRect.left - point.x, childRect.top - point.y, childRect.right - childRect.left, 
				childRect.bottom - childRect.top, TRUE );
			::ShowWindow( hSubDialog, SW_SHOWNORMAL );
			::SendDlgItemMessage( hWndDlg, IDC_WITHDRAWER_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			::SendDlgItemMessage( hWndDlg, IDC_THINK_TIME_EDIT, WM_SETTEXT, (WPARAM) 0, (LPARAM) "20" );
			::SendDlgItemMessage( hWndDlg, IDC_OPENING_BOOK_CHECK, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			return TRUE;
		}

	  case WM_COMMAND:
		switch( wParam )
		{
		  case IDOK:
			if( ::SendDlgItemMessage( hWndDlg, IDC_WITHDRAWER_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Withdrawer" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_COORDINATOR_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Coordinator" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_LONG_LEAPER_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Long Leaper" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_IMMOBILIZER_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Immobilizer" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ADVANCER_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Advancer" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SWAPPER_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Swapper" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_MIMOTAUR_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Mimotaur" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_PUSHME_PULLYU_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				StoreParameter( "ultima-piece", "Pushme-Pullyu" );
			whiteComp = ::SendDlgItemMessage( hSubDialog, IDC_COMPUTER_PLAYER0_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			blackComp = ::SendDlgItemMessage( hSubDialog, IDC_COMPUTER_PLAYER1_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			useOpeningBook = SendDlgItemMessage( hSubDialog, IDC_OPENING_BOOK_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			::SendDlgItemMessage( hSubDialog, IDC_THINK_TIME_EDIT, WM_GETTEXT, (WPARAM) 18, (LPARAM) buffer );
			maxThinkTime = atoi( buffer );
			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		}
		break;
	}
	return FALSE;
}
