
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__CWUP_GAME_H
#define FILE__CWUP_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"
#include "DecimalChessGame.h"


#define CWUP_VARIANT_WITHDRAWER			1
#define CWUP_VARIANT_COORDINATOR		2
#define CWUP_VARIANT_LONG_LEAPER		3
#define CWUP_VARIANT_IMMOBILIZER		4
#define CWUP_VARIANT_ADVANCER			5
#define CWUP_VARIANT_SWAPPER			6
#define CWUP_VARIANT_PUSHME_PULLYU		7
#define CWUP_VARIANT_MIMOTAUR			8


//	****************************
//	**                        **
//	**      ChessWUPGame      **
//	**                        **
//	****************************
//

class ChessWUPGame:
	public DecimalChessGame
{
  protected:
	int variant;

	//	helper functions
	void GenerateMovesForMimotaur
		( Piece *piece,
		  MovementList &stack, 
		  GameRec &gameRecord, 
	  	  bool quiescentSearch );


  public:
	// *** INITIALIZATION *** //
	ChessWUPGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );


	// *** DESTRUCTION *** //
	virtual ~ChessWUPGame();


	// ******************************* //
	// ***                         *** //
	// ***     VIRTUAL METHODS     *** //
	// ***                         *** //
	// ******************************* //

	virtual void SetPersonality
		( int personality );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual void DescribeMove
		( MoveInfo &move,
		  char *queryDescription,
		  char *description,
		  char *notation );

	virtual void AboutToGenerateMoves
		( int currentPlayer,
		  int currentDepth );

	virtual bool IsInCheck( Piece *king );
};


#endif
