
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__DECIMAL_CHESS_GAME_H
#define FILE__DECIMAL_CHESS_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"


//	******************************
//	**                          **
//	**     DecimalChessGame     **
//	**                          **
//	******************************

class DecimalChessGame:
	public Game
{
  protected:
	//	data members
	PieceType128 *rookPieceTypes[2];
	PieceType128 *minorPieceTypes[2][4];
	PieceType128 *colorboundPieceTypes[2][2];
	PieceType128 *majorPieceTypes[2][4];
	PieceType128 *pawnPieceTypes[2];
	
	HashMap *enPassantHashMap;
	//	Zobrist keys which are x-or'ed into the board's primary hash
	//	for the current "en passant" square, if any

	word32 castlingHash0k;	//	\   Zobrist keys for castling privledge.
	word32 castlingHash0q;	//	 \_ these values are x-or'ed in if the
	word32 castlingHash1k;	//	 /  player has not lost the ability to
	word32 castlingHash1q;	//	/   castle on the given side.

	//	variant information
	bool enPassant;			//	does this game have the en-passant rule?
	int castlingType;		//	castling type (none, standard, long, flexible, close-rook)
	int pawnPromotionType;	//	promotion type (standard, major)
	int pawnPromotionRank;	//	rank at which pawns promote
	bool kingsLeap;			//	archchess 'kings-leap' move allowed?
	bool bareKingRule;		//	true if Shatranj 'bare king' rule is in effect
	bool castleOutOfCheck;	//	ok to castle out of check?

	bool wackyPawnRestriction;
	//	wacky rule in archchess which prevents two-space initial pawn 
	//	move if the move blocks check and allows said pawn to be taken
	//	by enemy pawn en-passant.  such moves are illegal

	int pawnStartRank[2][10];
	//	keeps track of the starting rank of the pawn on each file.
	//	presently, this is only used during position evaluation to 
	//	penalize blocking center pawns in the opening


  public:
	// *** INITIALIZATION *** //
	DecimalChessGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void Initialize();

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );

	virtual void ChangeRulesByVariableDefinition( char *gameName );


	// ******************************* //
	// ***                         *** //
	// ***     VIRTUAL METHODS     *** //
	// ***                         *** //
	// ******************************* //

	virtual void SetPersonality
		( int personality );

	virtual bool RemovePieceType
		( PieceType *pieceType );

	virtual bool AddPieceType
		( PieceType *pieceType,
		  int nPlayer );

	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual bool TestForWinLossDraw
		( int &eval );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual word32 AdjustPrimaryHash
		( word32 primaryHash );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  PieceType **promotions,
		  bool quiescentSearch );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  Piece **pieces,
		  bool quiescentSearch );

	virtual Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual void DefaultSettings();
};


#endif
