
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "Decimal_Data.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


// *** PIECE SQUARE TABLES for the Decimal Board (10 x 10) ***
//
//	NOTE: all values are in milli-pawns


// *** The BISHOP *** //
//
//	in addition to these square bonuses, Bishops are elegible 
//	for an outpost bonus if they occupy an outpost square and 
//	are behind the enemy pawn line.  see Outposts below.

int bishopSquareBonuses_10x10[] = 
{
	25,  17, 10,   3,   0,   0,   3,  10,  17,  25,
	29,  53, 46,  38,  31,  31,  38,  46,  53,  29,
	44,  67, 91,  84,  84,  84,  84,  91,  67,  44,
	38,  62, 86,  102, 102, 102, 102, 86,  62,  38,
	33,  56, 87,  104, 135, 135, 104, 87,  56,  33,
	34,  58, 89,  106, 137, 137, 106, 89,  58,  34,
	44,  67, 91,  107, 107, 107, 107, 91,  67,  44,
	51,  76, 100, 93,  93,  93,  93,  100, 76,  51,
	56,  80, 75,  67,  60,  60,  67,  75,  80,  56,
	60,  55, 49,  42,  34,  34,  42,  49,  55,  60
};

int gcOpeningBishopSquareBonuses_10x10[] = 
{
   -90, -90, -90,  -90, -90, -90, -90, -90, -90, -90,
	29,  53, -30,   38,  31,  31,  38, -30,  53,  29,
	44,  67,  91,   84,  84,  84,  84,  91,  67,  44,
	38,  62,  86,  102, 102, 102, 102,  86,  62,  38,
	33,  56,  87,  104, 135, 135, 104,  87,  56,  33,
	34,  58,  89,  106, 137, 137, 106,  89,  58,  34,
	44,  67,  91,  107, 107, 107, 107,  91,  67,  44,
	51,  76, 100,   93,  93,  93,  93, 100,  76,  51,
	56,  80,  75,   67,  60,  60,  67,  75,  80,  56,
	60,  55,  49,   42,  34,  34,  42,  49,  55,  60
};


// *** The KNIGHT *** //
//
//	in addition to these square bonuses, Knights are elegible 
//	for an outpost bonus if they occupy an outpost square and 
//	are behind the enemy pawn line.  Knights have an outpost 
//	factor of 10, the highest of any piece.  see Outposts below.

int knightSquareBonuses_10x10[] = 
{
	-82, -74, -65, -64, -63, -63, -64, -65, -74, -82,
	-22, -44,  13,  14,  25,  25,  14,  13, -44, -22,
	  9,  34,  61,  62,  72,  72,  62,  61,  34,   9,
	 11,  36,  63,  64,  74,  74,  64,  63,  36,  11,
	 13,  48,  75,  76,  86,  86,  76,  75,  48,  13,
	 15,  50,  77,  78,  88,  88,  78,  77,  50,  15,
	 17,  43,  69,  70,  81,  81,  70,  69,  43,  17,
	 19,  45,  72,  73,  83,  83,  73,  72,  45,  19,
	  9,  19,  46,  47,  57,  57,  47,  46,  19,   9,
	 -2,   7,  18,  19,  20,  20,  19,  18,   7,  -2
};


// *** The QUEEN *** //
//
//	this table is also used for other pieces, such as the 
//	Ultima pieces in the Chess-with-Ultima-Pieces game

int queenSquareBonuses_10x10[] =
{
  -100,  -80,   0,   0,   0,   0,   0,   0,  -80, -100,
  -100,   20,  80,  80,  80,  80,  80,  80,   20, -100,
  -100,   20,  80,  80,  80,  80,  80,  80,   20, -100,
  -100, -100,  40, 100, 100, 100, 100,  40, -100, -100,
  -100,   20, 100, 120, 120, 120, 120, 100,   20, -100,
   -50,   20, 100, 120, 120, 120, 120, 100,   20,  -50,
   -50,   20,  40, 100, 100, 100, 100,  40,   20,  -50,
   -50,   20,  40, 100, 100, 100, 100,  40,   20,  -50,
  -150,   20,  60,  75,  75,  75,  75,  60,   20, -150,
     0,    0,   0,   0,   0,   0,   0,   0,    0,    0
};


// *** The MARSHALL *** //

int marshallSquareBonuses_10x10[] =
{
     0,    0,  30,  70,  70,  70,  70,  30,   0,    0,
     0,   20,  70,  90,  90,  90,  90,  70,  20,    0,
     0,   20,  70,  90,  90,  90,  90,  70,  20,    0,
     0,   20,  40, 100, 100, 100, 100,  40,  20,    0,
     0,   20, 100, 120, 120, 120, 120, 100,  20,    0,
     0,   20, 100, 120, 120, 120, 120, 100,  20,    0,
    30,   45,  40, 100, 100, 100, 100,  40,  45,   30,
    40,   55,  50, 100, 100, 100, 100,  50,  55,   40,
    50,   80,  80,  85,  95,  95,  85,  80,  80,   50,
     0,    0,   0,   0,   0,   0,   0,   0,   0,    0
};


// *** The ROOK *** //
//
//	in addition to these bonuses, the Rook can get 
//	two additional bonuses;
//
//	- Rook on Open File Bonus:
//		Rook is given a bonus if on a semi-open file, 
//		and a larger bonus if on a fully open file.
//	- Rook on Ninth Rank:
//		Rook is given a bonus if on the ninth rank, 
//		(the next to last rank), but only if the King 
//		is on the tenth rank

int rookSquareBonuses_10x10[] = 
{
 -20,  0,  40,  50,  60,  60,  50, 40,  0,-20,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0,
   0,  0,  40,  50,  60,  60,  50, 40,  0,  0
};

int gcOpeningRookSquareBonuses_10x10[] = 
{
 -20, -20, -10,   0, 100, 100,   0, -10, -20, -20,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0,
   0,   0,  40,  50,  60,  60,  50,  40,   0,   0
};


// *** The KING *** //
//
//	the King has two tables, one for the opening and 
//	mid-game, and another (completely different) one 
//	for the end-game, because the King needs to get 
//	in front of the pawns in the end-game.  of course, 
//	this is just based on king tables in standard 
//	Orthodox Chess ... these tables may be completely 
//	inappropriate for the Decimal board.

//	this table is used during the opening and mid-game
int kingSquareBonuses_10x10[] =
{
   240, 240, 240, 160, 160, 160, 160, 240, 320, 320,
   240, 200, 160, 120, 120, 120, 120, 160, 200, 240,
   160, 120,  80,  40,  40,  40,  40,  80, 120, 160,
   120,  80,  40,   0,   0,   0,   0,  40,  80, 120,
    60,   0,   0,   0,   0,   0,   0,   0,   0,  60,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

//	this table is used during the end-game, to encourage 
//	the king to move to the center of the board
int endgameKingSquareBonuses_10x10[] =
{
    0,  60, 120, 180, 180, 180, 180, 120,  60,   0,
   60, 120, 180, 240, 240, 240, 240, 180, 120,  60,
   60, 120, 180, 240, 240, 240, 240, 180, 120,  60,
  120, 180, 240, 320, 320, 320, 320, 240, 180, 120,
  180, 240, 320, 480, 480, 480, 480, 320, 240, 180,
  180, 240, 320, 480, 480, 480, 480, 320, 240, 180,
  120, 180, 240, 320, 320, 320, 320, 240, 180, 120,
   60, 120, 180, 240, 240, 240, 240, 180, 120,  60,
   60, 120, 180, 240, 240, 240, 240, 180, 120,  60,
    0,  60, 120, 180, 180, 180, 180, 120,  60,   0
};


// *** The PAWNS *** //

//	there are several tables here.  There are different 
//	tables for the opening, and for the mid/endgame. 
//	also, there are three different layouts.  the 
//	standard layout with pawns all on the second row, 
//	the unicorn chess layout with the two center pawns 
//	pushed forward to the third row, and the grand chess 
//	setup with all pawns on the third row.

//	opening bonuses for standard setup
int openingPawnSquareBonuses_10x10[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20,  20, -40, -40,  20,  20,  20,  20, 
  -40, -40,  30,  20,  20,  20,  20,  30, -40, -40, 
  -40, -20,  20,  20, 100, 100,  20,  20, -20, -20, 
  -40, -20,  20,  20, 100, 100,  20,  20, -20, -20, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0 
};

//	opening bonuses for grand chess setup
int openingPawnSquareBonuses_gc[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,   0,  15, -35, -90, -90, -35,  15,   0,  20, 
  -80, -80,  30,  30,  50,  50,  30,  30, -80, -80, 
  -80, -80,  40,  50, 100, 100,  50,  40, -80, -80, 
  -80, -80,  30,  50, 100, 100,  50,  30, -80, -80, 
    0,   0,  60,  60, 120, 120,  60,  60,   0,   0, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0 
};

//	opening bonuses for unicorn chess setup
int openingPawnSquareBonuses_uc[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,   0,   0, -60, -40, -40, -60,   0,   0,  20, 
  -40,  10,  30,   0, -80, -80,   0,  30,  10, -40, 
  -40,  40,  20,  60,  60,  60,  60,  20,  40, -20, 
  -40,  50,  20,  20, 100, 100,  20,  20,  50, -20, 
    0,   0,  20,  60, 100, 160,  60,  20,   0,   0, 
    0,   0,  20,  60, 100, 100,  60,  20,   0,   0, 
    0,   0,  20,  60, 100, 100,  60,  20,   0,   0, 
    0,   0,  20,  60, 100, 100,  60,  20,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0 
};

//	midgame and engame bonuses for standard setup
int pawnSquareBonuses_10x10[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20,  20, -40, -40,  20,  20,  20,  20, 
   20,  20,  30,  30,  20,  20,  30,  30,  20,  20, 
   20,  20,  30,  50, 100, 100,  50,  30,  20,  20, 
   30,  30,  50,  60, 200, 200,  60,  50,  30,  30, 
   40,  40,  60, 120, 180, 180, 120,  60,  40,  40, 
   70,  70,  60, 140, 200, 200, 140,  60,  70,  70, 
  100, 100,  60, 160, 240, 240, 160,  60, 100, 100, 
  100, 100,  60, 160, 240, 240, 160,  60, 100, 100, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

//	midgame bonuses for grand chess setup
int pawnSquareBonuses_gc[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20,  20, -40, -40,  20,  20,  20,  20, 
   20,  20,  30,  30,  20,  20,  30,  30,  20,  20, 
   20,  20,  30,  50, 100, 100,  50,  30,  20,  20, 
   30,  30,  75, 125, 200, 200, 125,  75,  30,  30, 
   75,  90, 120, 140, 180, 180, 140, 120,  90,  75, 
   75, 100, 140, 150, 200, 200, 150, 140, 100,  75, 
   75, 100, 140, 160, 200, 200, 160, 140, 100,  75, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

//	endgame bonuses for grand chess setup
int endgamePawnSquareBonuses_gc[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   10,  10,  20,  30,  30,  30,  30,  20,  10,  10, 
   20,  20,  30,  40,  50,  50,  40,  30,  20,  20, 
   40,  50,  75, 125, 200, 200, 125,  75,  50,  40, 
   80, 100, 150, 180, 200, 200, 180, 150, 100,  80, 
   90, 110, 160, 200, 200, 200, 200, 160, 110,  90, 
   90, 110, 160, 200, 200, 200, 200, 160, 110,  90, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

//	midgame and engame bonuses for unicorn chess setup
int pawnSquareBonuses_uc[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
	0,   0,   0, -40,   0,   0, -40,   0,   0,   0, 
   20,  20,  20, -20,-100,-100, -20,  20,  20,  20, 
   20,  20,  30,  30,  60,  60,  30,  30,  20,  20, 
   20,  20,  30,  60, 100, 100,  60,  30,  20,  20, 
   30,  30,  75, 125, 200, 200, 125,  75,  30,  30, 
   40,  40,  90, 120, 180, 180, 120,  90,  40,  40, 
  150, 150, 150, 160, 240, 240, 160, 150, 150, 150, 
  150, 150, 150, 160, 240, 240, 160, 150, 150, 150, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};


// *** MISCELLANEOUS *** //

int knightWazirSquareBonuses_10x10[] = 
{
	-12,  2, 17, 25,  34,  34, 25, 17,  2, -12,
	  4, 18, 40, 48,  57,  57, 48, 40, 18,   4,
	 13, 34, 56, 72,  80,  80, 72, 56, 34,  13,
	 15, 36, 66, 81,  97,  97, 81, 66, 36,  15,
	 17, 38, 68, 91, 106, 106, 91, 68, 38,  17,
	 19, 40, 70, 93, 109, 109, 93, 70, 40,  19,
	 21, 42, 72, 88, 103, 103, 88, 72, 42,  21,
	 23, 44, 67, 82,  91,  91, 82, 67, 44,  23,
	 14, 30, 53, 61,  69,  69, 61, 53, 30,  14,
	 -2, 12, 30, 38,  46,  46, 38, 30, 12,  -2
};

int wizardSquareBonuses_10x10[] = 
{
	-6,11,20,29,39,39,29,20,11,-6,
	13,37,47,64,73,73,64,47,37,13,
	25,49,69,85,95,95,85,69,49,25,
	35,68,88,104,114,114,104,88,68,35,
	47,80,100,116,116,116,116,100,80,47,
	49,82,102,118,118,118,118,102,82,49,
	41,74,94,110,120,120,110,94,74,41,
	33,58,77,94,104,104,94,77,58,33,
	21,46,56,72,82,82,72,56,46,21,
	3,19,29,37,47,47,37,29,19,3
};

int championSquareBonuses_10x10[] = 
{
	-10,-2,15,16,17,17,16,15,-2,-10,
	0,15,32,40,41,41,40,32,15,0,
	18,33,58,74,75,75,74,58,33,18,
	20,43,75,91,99,99,91,75,43,20,
	22,45,77,100,108,108,100,77,45,22,
	24,47,79,102,111,111,102,79,47,24,
	26,49,81,97,105,105,97,81,49,26,
	28,44,69,84,85,85,84,69,44,28,
	10,28,45,53,54,54,53,45,28,10,
	0,8,27,28,29,29,28,27,8,0
};

int lionSquareBonuses_10x10[] = 
{
	-9,   6,  13,  13,  13,  13,  13,  13,   6,  -9,
	 8,  30,  37,  45,  45,  45,  45,  37,  30,  8,
	17,  39,  55,  71,  80,  80,  71,  55,  39,  17,
	19,  49,  73,  90, 107, 107,  90,  73,  49,  19,
	21,  52,  84, 109, 134, 134, 109,  84,  52,  21,
	23,  54,  86, 111, 136, 136, 111,  86,  54,  23,
	26,  56,  80,  96, 113, 113,  96,  80,  56,  26,
	26,  47,  63,  80,  88,  88,  80,  63,  47,  26,
	16,  38,  45,  54,  54,  54,  54,  45,  38,  16,
	-1,  14,  21,  21,  21,  21,  21,  21,  14,  -1
};

int genericLargeCenterBonuses_10x10[] =
{
   -90,  -70, -70, -70, -70, -70,  -70,  -90,
   -70,    0,   0,   0,   0,   0,    0,  -70,
   -70,    0,  30,  60,  60,  30,    0,  -70,
   -70,    0,  60,  90,  90,  60,    0,  -70,
   -70,    0,  90, 160, 160,  90,    0,  -70,
   -70,    0,  90, 160, 160,  90,    0,  -70,
   -70,    0,  70, 100, 100,  70,    0,  -70,
   -70,    0,  50,  90,  90,  50,    0,  -70,
   -70,    0,  15,  15,  15,  15,    0,  -70,
   -90,  -70, -70, -70, -70, -70,  -70,  -90
};



// ************************** //
// **                      ** //
// **    OUTPOST values    ** //
// **                      ** //
// ************************** //

//	Knights, Bishops, and other "postable pieces" (such 
//	as the Lion in Unicorn Chess) are given a bonus as 
//	indicated here, if they occupy one of these outpost 
//	squares.  BUT, this bonus is only assigned if the posted 
//	piece is not and cannot be attacked by an enemy pawn 
//	(because it's behind the pawns on adjacent files, or 
//	because those pawns are already captured.)
	
//	IMPORTANT: don't put non-zero values on the left-most 
//	or right-most files!  the outpost code checks for 
//	pawns to the left and right, and it doesn't check to 
//	make sure that that's not off the edge of the board! 
//	you wouldn't want an outpost on the rim anyway.

//	these values are multipliers, which are scaled by the 
//	piece's 'outpost' factor, stored in gameInt1.  
//	the Knight is the most valuble posted piece, with an 
//	outpost factor of 10.

int outpost_10x10[] = 
{
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   4,   6,   6,   4,   0,   0,   0,
    0,   0,   4,   8,   8,   8,   8,   4,   0,   0,
    0,   0,  12,  14,  14,  14,  14,  12,   0,   0,
    0,   0,  12,  16,  16,  16,  16,  12,   0,   0,
    0,   0,   9,  16,  16,  16,  16,   9,   0,   0,
    0,   0,   6,  12,  12,  12,  12,   6,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};


//	zero matrix, for pieces without square values 
//	and other purposes
int zeroes_10x10[] = 
{
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

