
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "Decimal_Types.h"
#include "../../GUI/Brush.h"
#include "../../GUI/Pen.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


//	instances of the PieceTypes
DecimalPawn DecimalPawn::decimalPawn;
DecimalLamePawn DecimalLamePawn::decimalLamePawn;
GrandChessPawn GrandChessPawn::grandChessPawn;
Decimal3StepPawn Decimal3StepPawn::decimal3StepPawn;
UnicornChessPawn UnicornChessPawn::unicornChessPawn;
DecimalKing DecimalKing::decimalKing;
DecimalQueen DecimalQueen::decimalQueen;
DecimalRook DecimalRook::decimalRook;
DecimalCleric DecimalCleric::decimalCleric;
DecimalKnight DecimalKnight::decimalKnight;
DecimalBishop DecimalBishop::decimalBishop;
DecimalCamel DecimalCamel::decimalCamel;
DecimalChancellor DecimalChancellor::decimalChancellor;
DecimalArchbishop DecimalArchbishop::decimalArchbishop;
DecimalAmazon DecimalAmazon::decimalAmazon;
DecimalUnicorn DecimalUnicorn::decimalUnicorn;
DecimalLion DecimalLion::decimalLion;
DecimalChampion DecimalChampion::decimalChampion;
DecimalCamelFerz DecimalCamelFerz::decimalCamelFerz;
DecimalKnightWazir DecimalKnightWazir::decimalKnightWazir;
DecimalSquirrel DecimalSquirrel::decimalSquirrel;
DecimalElephant DecimalElephant::decimalElephant;
DecimalDabbabah DecimalDabbabah::decimalDabbabah;
DecimalFerz DecimalFerz::decimalFerz;
DecimalWazir DecimalWazir::decimalWazir;
DecimalGeneral DecimalGeneral::decimalGeneral;
DecimalWithdrawer DecimalWithdrawer::decimalWithdrawer;
DecimalCoordinator DecimalCoordinator::decimalCoordinator;
DecimalLongLeaper DecimalLongLeaper::decimalLongLeaper;
DecimalImmobilizer DecimalImmobilizer::decimalImmobilizer;
DecimalAdvancer DecimalAdvancer::decimalAdvancer;
DecimalSwapper DecimalSwapper::decimalSwapper;
DecimalPushmePullyu DecimalPushmePullyu::decimalPushmePullyu;
DecimalMimotaur DecimalMimotaur::decimalMimotaur;
DecimalCannon DecimalCannon::decimalCannon;
DecimalVao DecimalVao::decimalVao;


extern void FindIntersectionOfLineAndRectangle
	( int lineStartX,
	  int lineStartY,
	  int lineEndX,
	  int lineEndY,
	  int rectLeft, 
	  int rectTop, 
	  int rectRight, 
	  int rectBottom, 
	  int &intersectX, 
	  int &intersectY );


void DecimalOdinsPawn::PostPaintMoveDiagram
	( LPPAINTSTRUCT ps, 
	  HDC hdc )
{
	//	draw the red dot for the forward-most movement, as that one 
	//	doesn't appear otherwise (since it is a special move added in 
	//	AddSpecialMoves().  so, we'll draw it in now
	Brush fillBr;
	Pen outlinePen;
	fillBr.CreateSolidBrush( RGB(255, 0, 0) );
	outlinePen.CreateSolidPen( RGB(0, 0, 0), 2 );
	::SelectObject( hdc, outlinePen );
	::SelectObject( hdc, fillBr );
	::Ellipse( hdc, 123 + 36 * 4, 224 + 36 * 2, 151 + 36 * 4, 252 + 36 * 2 );

	//	draw the red strips which indicate that this is a sliding move
	int nextSquareCenterX;
	int nextSquareCenterY;
	int lineEndX;
	int lineEndY;
	Brush fillBrush;
	Pen linePen;
	linePen.CreateSolidPen( RGB(255, 0, 0), 5 );
	fillBrush.CreateSolidBrush( RGB(255, 0, 0) );
	lineEndX = 137 + (36 * 3);
	lineEndY = 238 + (36 * 3);
	nextSquareCenterX = 137 + (36 * 3);
	nextSquareCenterY = 238 + (36 * 3);
	int lineStartX = 137 + (36 * 4);
	int lineStartY = 238 + (36 * 4);
	FindIntersectionOfLineAndRectangle( 281, 382, nextSquareCenterX, 
		nextSquareCenterY, 120 + (36 * 4), 221 + (36 * 4), 153 + (36 * 4), 254 + (36 * 4), 
		lineStartX, lineStartY );
	::SelectObject( hdc, linePen );
	::SelectObject( hdc, fillBrush );
	::MoveToEx( hdc, lineStartX, lineStartY, NULL );
	::LineTo( hdc, lineEndX, lineEndY );
	lineEndX = 137 + (36 * 5);
	lineEndY = 238 + (36 * 5);
	nextSquareCenterX = 137 + (36 * 5);
	nextSquareCenterY = 238 + (36 * 5);
	lineStartX = 137 + (36 * 4);
	lineStartY = 238 + (36 * 4);
	FindIntersectionOfLineAndRectangle( 281, 382, nextSquareCenterX, 
		nextSquareCenterY, 120 + (36 * 4), 221 + (36 * 4), 153 + (36 * 4), 254 + (36 * 4), 
		lineStartX, lineStartY );
	::MoveToEx( hdc, lineStartX, lineStartY, NULL );
	::LineTo( hdc, lineEndX, lineEndY );
	lineEndX = 137 + (36 * 3);
	lineEndY = 238 + (36 * 5);
	nextSquareCenterX = 137 + (36 * 3);
	nextSquareCenterY = 238 + (36 * 5);
	lineStartX = 137 + (36 * 4);
	lineStartY = 238 + (36 * 4);
	FindIntersectionOfLineAndRectangle( 281, 382, nextSquareCenterX, 
		nextSquareCenterY, 120 + (36 * 4), 221 + (36 * 4), 153 + (36 * 4), 254 + (36 * 4), 
		lineStartX, lineStartY );
	::MoveToEx( hdc, lineStartX, lineStartY, NULL );
	::LineTo( hdc, lineEndX, lineEndY );
	lineEndX = 137 + (36 * 5);
	lineEndY = 238 + (36 * 3);
	nextSquareCenterX = 137 + (36 * 5);
	nextSquareCenterY = 238 + (36 * 3);
	lineStartX = 137 + (36 * 4);
	lineStartY = 238 + (36 * 4);
	FindIntersectionOfLineAndRectangle( 281, 382, nextSquareCenterX, 
		nextSquareCenterY, 120 + (36 * 4), 221 + (36 * 4), 153 + (36 * 4), 254 + (36 * 4), 
		lineStartX, lineStartY );
	::MoveToEx( hdc, lineStartX, lineStartY, NULL );
	::LineTo( hdc, lineEndX, lineEndY );
	lineEndX = 137 + (36 * 4);
	lineEndY = 238 + (36 * 2);
	nextSquareCenterX = 137 + (36 * 4);
	nextSquareCenterY = 238 + (36 * 2);
	lineStartX = 137 + (36 * 3);
	lineStartY = 238 + (36 * 3);
	::MoveToEx( hdc, lineStartX, lineStartY, NULL );
	::LineTo( hdc, lineEndX, lineEndY );
	lineEndX = 137 + (36 * 4);
	lineEndY = 238 + (36 * 2);
	nextSquareCenterX = 137 + (36 * 4);
	nextSquareCenterY = 238 + (36 * 2);
	lineStartX = 137 + (36 * 5);
	lineStartY = 238 + (36 * 3);
	::MoveToEx( hdc, lineStartX, lineStartY, NULL );
	::LineTo( hdc, lineEndX, lineEndY );
	

	//	draw black inner dots
	::SelectObject( hdc, ::GetStockObject( BLACK_BRUSH ) );
	::SelectObject( hdc, (HPEN) ::GetStockObject( NULL_PEN ) );
	::Ellipse( hdc, 132 + 36 * 3, 233 + 36 * 3, 145 + 36 * 3, 244 + 36 * 3 );
	::Ellipse( hdc, 132 + 36 * 5, 233 + 36 * 3, 145 + 36 * 5, 244 + 36 * 3 );
	::Ellipse( hdc, 132 + 36 * 3, 233 + 36 * 5, 145 + 36 * 3, 244 + 36 * 5 );
	::Ellipse( hdc, 132 + 36 * 5, 233 + 36 * 5, 145 + 36 * 5, 244 + 36 * 5 );
	::Ellipse( hdc, 132 + 36 * 4, 233 + 36 * 2, 145 + 36 * 4, 244 + 36 * 2 );
	
}

