
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__DECIMAL_TYPES_H
#define FILE__DECIMAL_TYPES_H


#include "../../PieceType.h"
#include "../../Personality.h"
#include "Decimal_Data.h"


class DecimalRook:
	public PieceType128
{
  public:
	//	construction
	DecimalRook():
		PieceType128("Rook", "Rook", "R", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BRook.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WRook.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BRook.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WRaidho.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BRaidho.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6000;
		}
		else
		{
			baseValue = 5500;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
		}

		SetSquareBonuses( 0, rookSquareBonuses_10x10 );
		SetSquareBonuses( 1, rookSquareBonuses_10x10 );
		SetSquareBonuses( 2, zeroes_10x10 );
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -9 );
		SetTropism( 7, -10 );
		SetTropism( 8, -10 );
		SetTropism( 9, -10 );
		optimization = SimpleSlider;
	}

	static DecimalRook decimalRook;
};

class DecimalCleric:
	public PieceType128
{
  public:
	//	construction
	DecimalCleric():
		PieceType128("Cleric", "Cleric", "C", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishopWarMachine.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\WBishopWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BRook.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WRook.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BRook.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WRaidho.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BRaidho.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		}

		SetSquareBonuses( 0, bishopSquareBonuses_10x10 );
		SetSquareBonuses( 1, bishopSquareBonuses_10x10 );
		SetSquareBonuses( 2, zeroes_10x10 );
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -9 );
		SetTropism( 7, -10 );
		SetTropism( 8, -10 );
		SetTropism( 9, -10 );
		baseValue = 5000;
		perCaptureValueBonus = 50;
		perCaptureBonusThreshold = 12;
	}

	static DecimalCleric decimalCleric;
};

class DecimalBishop:
	public PieceType128
{
  public:
	//	construction
	DecimalBishop():
		PieceType128("Bishop", "Bishop", "B", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCourier.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCourier.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WBeorc.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BBeorc.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 4000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 3750;
			perCaptureValueBonus = 35;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 1, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 2, bishopSquareBonuses_10x10 );
		}

		SetMobility( StandardMobility, -7, 24 );
		optimization = SimpleSlider;
	}

	static DecimalBishop decimalBishop;
};

class DecimalKnight:
	public PieceType128
{
  public:
	//	construction
	DecimalKnight():
		PieceType128("Knight", "Knight", "N", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 2350;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, knightSquareBonuses_10x10 );
			SetSquareBonuses( 1, knightSquareBonuses_10x10 );
			SetSquareBonuses( 2, knightSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalKnight decimalKnight;
};

class DecimalQueen:
	public PieceType128
{
  public:
	//	construction
	DecimalQueen():
		PieceType128("Queen", "Queen", "Q", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9275;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, zeroes_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		optimization = SimpleSlider;
	}

	static DecimalQueen decimalQueen;
};

class DecimalPawn:
	public PieceType128
{
  public:
	//	construction
	DecimalPawn():
		PieceType128("Pawn", "Pawn", "P", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 2, MoveOnly, 0, 19 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly, 20, 99 ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_10x10 );
		SetSquareBonuses( 1, pawnSquareBonuses_10x10 );
		SetSquareBonuses( 2, pawnSquareBonuses_10x10 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		isPawn = true;
	}

	static DecimalPawn decimalPawn;
};

class DecimalLamePawn:
	public PieceType128
{
  public:
	//	construction
	DecimalLamePawn():
		PieceType128("Lame Pawn", "Pawn", "P", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_10x10 );
		SetSquareBonuses( 1, pawnSquareBonuses_10x10 );
		SetSquareBonuses( 2, pawnSquareBonuses_10x10 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		isPawn = true;
	}

	static DecimalLamePawn decimalLamePawn;
};

class Decimal3StepPawn:
	public PieceType128
{
  public:
	//	construction
	Decimal3StepPawn():
		PieceType128("3-Step Pawn", "Pawn", "P", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 3, MoveOnly, 0, 19 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly, 20, 99 ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_10x10 );
		SetSquareBonuses( 1, pawnSquareBonuses_10x10 );
		SetSquareBonuses( 2, pawnSquareBonuses_10x10 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		isPawn = true;
	}

	static Decimal3StepPawn decimal3StepPawn;
};

class GrandChessPawn:
	public PieceType128
{
  public:
	//	construction
	GrandChessPawn():
		PieceType128("Grand Chess Pawn", "Pawn", "P", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 2, MoveOnly, 0, 29 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly, 30, 99 ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_gc );
		SetSquareBonuses( 1, pawnSquareBonuses_gc );
		SetSquareBonuses( 2, endgamePawnSquareBonuses_gc );
		promotion.SetPromotionCapability( PromoteByReplacement );
		isPawn = true;
	}

	static GrandChessPawn grandChessPawn;
};

class UnicornChessPawn:
	public PieceType128
{
  public:
	//	construction
	UnicornChessPawn():
		PieceType128("Unicorn Chess Pawn", "Pawn", "P", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			MovementCapability &pawnMove1 = AddMovementCapability(
				MovementCapability(  0, 1, 2, MoveOnly, 0, 19 ) );
			pawnMove1.GetRestrictionZone().AddToZone( 24, 25 );
			MovementCapability &pawnMove2 = AddMovementCapability(
				MovementCapability(  0, 1, 1, MoveOnly, 30, 99 ) );
			pawnMove2.GetRestrictionZone().AddToZone( 20, 23 );
			pawnMove2.GetRestrictionZone().AddToZone( 26, 29 );
		}
		promotion.SetPromotionCapability( PromoteToVariableTypes );

		baseValue = 1000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_uc );
		SetSquareBonuses( 1, pawnSquareBonuses_uc );
		SetSquareBonuses( 2, pawnSquareBonuses_uc );
		isPawn = true;
	}

	static UnicornChessPawn unicornChessPawn;
};

class DecimalKing:
	public PieceType128
{
  public:
	//	construction
	DecimalKing():
		PieceType128("King", "King", "K", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKing.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WKing.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 100000;
		SetSquareBonuses( 0, kingSquareBonuses_10x10 );
		SetSquareBonuses( 1, kingSquareBonuses_10x10 );
		SetSquareBonuses( 2, endgameKingSquareBonuses_10x10 );
		optimization = SimpleSingleStep;
		isRoyal = true;
	}

	static DecimalKing decimalKing;
};

class DecimalArchbishop:
	public PieceType128
{
  public:
	//	construction
	DecimalArchbishop():
		PieceType128("Archbishop", "Archbishop", "A", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCardinal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCardinal2.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCardinal.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCardinal.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WArchbishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BArchbishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\motif\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\motif\\BCommoner.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 7000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 6500;
			perCaptureValueBonus = 25;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 1, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 2, bishopSquareBonuses_10x10 );
		}

		SetMobility( StandardMobility, -4, 8 );
		SetTropismType( DistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -1 );
		SetTropism( 3, -3 );
		SetTropism( 4, -5 );
		SetTropism( 5, -7 );
		SetTropism( 6, -7 );
		SetTropism( 7, -7 );
	}

	static DecimalArchbishop decimalArchbishop;
};

class DecimalChancellor:
	public PieceType128
{
  public:
	//	construction
	DecimalChancellor():
		PieceType128("Chancellor", "Chancellor", "C", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WMarshal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BMarshal2.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 8250;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9000;
			SetSquareBonuses( 0, marshallSquareBonuses_10x10 );
			SetSquareBonuses( 1, marshallSquareBonuses_10x10 );
			SetSquareBonuses( 2, marshallSquareBonuses_10x10 );
		}

		SetMobility( StandardMobility, -4, 8 );
		SetTropismType( DistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -1 );
		SetTropism( 3, -3 );
		SetTropism( 4, -5 );
		SetTropism( 5, -7 );
		SetTropism( 6, -7 );
		SetTropism( 7, -7 );
	}

	static DecimalChancellor decimalChancellor;
};

class DecimalAmazon:
	public PieceType128
{
  public:
	//	construction
	DecimalAmazon():
		PieceType128("Amazon", "Amazon", "Z", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WAmazon.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BAmazon.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WAmazon.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BAmazon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WAmazon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BAmazon.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCounsellor.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCounsellor.bmp";
			//	add bishop moves
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			//	add rook moves
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			//	add knight moves
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 12000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 11000;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetMobility( StandardMobility, -4, 8 );
		SetTropismType( DistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -1 );
		SetTropism( 3, -3 );
		SetTropism( 4, -5 );
		SetTropism( 5, -7 );
		SetTropism( 6, -7 );
		SetTropism( 7, -7 );
	}

	static DecimalAmazon decimalAmazon;
};

class DecimalLion:
	public PieceType128
{
  public:
	//	construction
	DecimalLion():
		PieceType128("Lion", "Lion", "L", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLion.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLion.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WLion.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BLion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WHalfDuck.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BHalfDuck.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WLion.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BLion.bmp";
			AddMovementCapability( MovementCapability(  0,  3, 1 ) );
			AddMovementCapability( MovementCapability(  3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 4000;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, lionSquareBonuses_10x10 );
			SetSquareBonuses( 1, lionSquareBonuses_10x10 );
			SetSquareBonuses( 2, lionSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalLion decimalLion;
};

class DecimalKnightWazir:
	public PieceType128
{
  public:
	//	construction
	DecimalKnightWazir():
		PieceType128("Knight-Wazir", "Knight", "N", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		}

		baseValue = 4000;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, knightWazirSquareBonuses_10x10 );
			SetSquareBonuses( 1, knightWazirSquareBonuses_10x10 );
			SetSquareBonuses( 2, knightWazirSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalKnightWazir decimalKnightWazir;
};

class DecimalKnightGeneral:
	public PieceType128
{
  public:
	//	construction
	DecimalKnightGeneral():
		PieceType128("Knight-General", "Knight-General", "N", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawnKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawnKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WGeneral.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BGeneral.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		}

		baseValue = 5500;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, knightWazirSquareBonuses_10x10 );
			SetSquareBonuses( 1, knightWazirSquareBonuses_10x10 );
			SetSquareBonuses( 2, knightWazirSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalKnightGeneral decimalKnightGeneral;
};

class DecimalCamelFerz:
	public PieceType128
{
  public:
	//	construction
	DecimalCamelFerz():
		PieceType128("Camel-Ferz", "Wizard", "W", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WMage.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BMage.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCamelFerz.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCamelFerz.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WMage.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BMage.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWizard.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWizard.bmp";
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 3900;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, wizardSquareBonuses_10x10 );
			SetSquareBonuses( 1, wizardSquareBonuses_10x10 );
			SetSquareBonuses( 2, wizardSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalCamelFerz decimalCamelFerz;
};

class DecimalCamel:
	public PieceType128
{
  public:
	//	construction
	DecimalCamel():
		PieceType128("Camel", "Camel", "C", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamel.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamel.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCamel.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCamel.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WCamel.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BCamel.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCamel.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCamel.bmp";
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		baseValue = 2150;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, wizardSquareBonuses_10x10 );
			SetSquareBonuses( 1, wizardSquareBonuses_10x10 );
			SetSquareBonuses( 2, wizardSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalCamel decimalCamel;
};

class DecimalChampion:
	public PieceType128
{
  public:
	//	construction
	DecimalChampion():
		PieceType128("Champion", "Champion", "C", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WChampion.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BChampion.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WChampion.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BChampion.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WMage.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BMage.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WChampion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BChampion.bmp";
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		}

		baseValue = 4000;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, championSquareBonuses_10x10 );
			SetSquareBonuses( 1, championSquareBonuses_10x10 );
			SetSquareBonuses( 2, championSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalChampion decimalChampion;
};

class DecimalSquirrel:
	public PieceType128
{
  public:
	//	construction
	DecimalSquirrel():
		PieceType128("Squirrel", "Squirrel", "S", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSquirrel.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSquirrel.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGuard.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WLion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BLion.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 6500;

	}

	static DecimalSquirrel decimalSquirrel;
};

class DecimalFerz:
	public PieceType128
{
  public:
	//	construction
	DecimalFerz():
		PieceType128("Ferz", "Ferz", "F", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFerz.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WFerz.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFers.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFers.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCounsellor.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCounsellor.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 1850;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalFerz decimalFerz;
};

class DecimalWazir:
	public PieceType128
{
  public:
	//	construction
	DecimalWazir():
		PieceType128("Wazir", "Wazir", "W", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWazir.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWazir.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BWazir.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		}

		baseValue = 1700;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalWazir decimalWazir;
};

class DecimalElephant:
	public PieceType128
{
  public:
	//	construction
	DecimalElephant():
		PieceType128("Elephant", "Elephant", "E", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		}

		baseValue = 1000;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 1, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 2, bishopSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalElephant decimalElephant;
};

class DecimalElephantFerz:
	public PieceType128
{
  public:
	//	construction
	DecimalElephantFerz():
		PieceType128("Elephant-Ferz", "Elephant", "E", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 1000;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 1, bishopSquareBonuses_10x10 );
			SetSquareBonuses( 2, bishopSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalElephantFerz decimalElephantFerz;
};

class DecimalDabbabah:
	public PieceType128
{
  public:
	//	construction
	DecimalDabbabah():
		PieceType128("Dabbabah", "Dabbabah", "D", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWarMachine.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWarMachine.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WWarMachine.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BWarMachine.bmp";
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		}

		baseValue = 1800;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, knightSquareBonuses_10x10 );
			SetSquareBonuses( 1, knightSquareBonuses_10x10 );
			SetSquareBonuses( 2, knightSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalDabbabah decimalDabbabah;
};

class DecimalGeneral:
	public PieceType128
{
  public:
	//	construction
	DecimalGeneral():
		PieceType128("General", "Commoner", "C", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WGuard.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGuard.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 3200;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		optimization = SimpleSingleStep;
	}

	static DecimalGeneral decimalGeneral;
};

class DecimalCannon:
	public PieceType128
{
  public:
	//	construction
	DecimalCannon():
		PieceType128("Cannon", "Cannon", "C", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCannon.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCannon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCannon.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCannon.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BCannon.bmp";
		}

		SetSquareBonuses( 0, gcOpeningRookSquareBonuses_10x10 );
		SetSquareBonuses( 1, rookSquareBonuses_10x10 );
		SetSquareBonuses( 2, zeroes_10x10 );

		baseValue = 4600;
		perCaptureValueBonus = -40;
		perCaptureBonusThreshold = 6;
	}

	static DecimalCannon decimalCannon;
};

class DecimalVao:
	public PieceType128
{
  public:
	//	construction
	DecimalVao():
		PieceType128("Vao", "Vao", "V", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WVao.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BVao.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WVao.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BVao.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WVao.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BVao.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WVao.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BVao.bmp";
		}

		SetSquareBonuses( 0, zeroes_10x10 );
		SetSquareBonuses( 1, bishopSquareBonuses_10x10 );
		SetSquareBonuses( 2, zeroes_10x10 );

		baseValue = 2500;
		perCaptureValueBonus = -50;
		perCaptureBonusThreshold = 6;
	}

	static DecimalVao decimalVao;
};

class DecimalUnicorn:
	public PieceType128
{
  public:
	//	construction
	DecimalUnicorn():
		PieceType128("Unicorn", "Unicorn", "U", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WUnicorn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BUnicorn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WUnicorn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BUnicorn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WNightPrincess.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BNightPrincess.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 0 ) );
			AddMovementCapability( MovementCapability(  1,  2, 0 ) );
			AddMovementCapability( MovementCapability( -2,  1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 0 ) );
			AddMovementCapability( MovementCapability(  1, -2, 0 ) );
			AddMovementCapability( MovementCapability( -2, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9500;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, zeroes_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		optimization = SimpleSlider;
	}

	static DecimalUnicorn decimalUnicorn;
};

class DecimalWithdrawer:
	public PieceType128
{
  public:
	//	construction
	DecimalWithdrawer():
		PieceType128("Withdrawer", "Withdrawer", "_WD", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWithdrawer.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability( -1,  0, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  0,  1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  0, -1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  1,  1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability( -1,  1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  1, -1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability( -1, -1, 0, MoveOnly, 0, 99, true, false ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 8750;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 8600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 5 );
		SetTropism( 2, 2 );
		SetTropism( 3, 1 );
	}

	static DecimalWithdrawer decimalWithdrawer;
};

class DecimalAdvancer:
	public PieceType128
{
  public:
	//	construction
	DecimalAdvancer():
		PieceType128("Advancer", "Advancer", "_AD", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRam.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRam.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WAdvancer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BAdvancer.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability( -1,  0, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability(  0,  1, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability(  0, -1, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability(  1,  1, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability( -1,  1, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability(  1, -1, 0, MoveOnly, 0, 99, false, true ) );
			AddMovementCapability( MovementCapability( -1, -1, 0, MoveOnly, 0, 99, false, true ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10500;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, -3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static DecimalAdvancer decimalAdvancer;
};

class DecimalCoordinator:
	public PieceType128
{
  public:
	//	construction
	DecimalCoordinator():
		PieceType128("Coordinator", "Coordinator", "_CO", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCoordinator.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCoordinator.bmp";
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );

		}
		else
		{
			baseValue = 9000;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetTropismType( HVDistanceTropism );
		SetTropism( 0, 7 );
		SetTropism( 1, 5 );
		SetTropism( 2, 2 );
		SetTropism( 3, 1 );
	}

	static DecimalCoordinator decimalCoordinator;
};

class DecimalLongLeaper:
	public PieceType128
{
  public:
	//	construction
	DecimalLongLeaper():
		PieceType128("Long Leaper", "Long Leaper", "_LL", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BLongLeaper.bmp";
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetTropismType( HVDistanceTropism );
		SetTropism( 0, 5 );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static DecimalLongLeaper decimalLongLeaper;
};

class DecimalImmobilizer:
	public PieceType128
{
  public:
	//	construction
	DecimalImmobilizer():
		PieceType128("Immobilizer", "Immobilizer", "_IM", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BImmobilizer.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1,  0, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  0,  1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  0, -1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  1,  1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1,  1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  1, -1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1, -1, 0, MoveOnly ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 8600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 12 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
	}

	static DecimalImmobilizer decimalImmobilizer;
};

class DecimalSwapper:
	public PieceType128
{
  public:
	//	construction
	DecimalSwapper():
		PieceType128("Swapper", "Swapper", "_SW", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSwapper.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSwapper.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WSwapper.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BSwapper.bmp";
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9600;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}
	}

	static DecimalSwapper decimalSwapper;
};

class DecimalPushmePullyu:
	public PieceType128
{
  public:
	//	construction
	DecimalPushmePullyu():
		PieceType128("Pushme-Pullyu", "Pushme-Pullyu", "_PP", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WMagneticPrincess.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BMagneticPrincess.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPushme-pullyu.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPushme-pullyu.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability( -1,  0, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability(  0,  1, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability(  0, -1, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability(  1,  1, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability( -1,  1, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability(  1, -1, 0, MoveOnly, 0, 99, true, true ) );
			AddMovementCapability( MovementCapability( -1, -1, 0, MoveOnly, 0, 99, true, true ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}
	}

	static DecimalPushmePullyu decimalPushmePullyu;
};

class DecimalMimotaur:
	public PieceType128
{
  public:
	//	construction
	DecimalMimotaur():
		PieceType128("Mimotaur", "Mimotaur", "_MT", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPrincess.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPrincess.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKit.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKit.bmp";
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9600;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, queenSquareBonuses_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}
	}

	static DecimalMimotaur decimalMimotaur;
};

class DecimalForestOx:
	public PieceType128
{
  public:
	//	construction
	DecimalForestOx():
		PieceType128("Forest Ox", "Forest Ox", "F", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WOx.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BOx.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WUruz.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BUruz.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9250;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			baseValue = 9500;
			perCaptureValueBonus = -50;
			perCaptureBonusThreshold = 6;
			SetSquareBonuses( 0, knightSquareBonuses_10x10 );
			SetSquareBonuses( 1, knightSquareBonuses_10x10 );
			SetSquareBonuses( 2, knightSquareBonuses_10x10 );
		}
	}

	static DecimalForestOx decimalForestOx;
};

class DecimalValkyrie:
	public PieceType128
{
  public:
	//	construction
	DecimalValkyrie():
		PieceType128("Valkyrie", "Valkyrie", "V", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WPerdhro.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BPerdhro.bmp";
		}

		baseValue = 9500;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x10 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x10 );
		}
		else
		{
			SetSquareBonuses( 0, zeroes_10x10 );
			SetSquareBonuses( 1, queenSquareBonuses_10x10 );
			SetSquareBonuses( 2, queenSquareBonuses_10x10 );
		}
	}

	static DecimalValkyrie decimalValkyrie;
};

class DecimalOdinsPawn:
	public PieceType128
{
  public:
	//	construction
	DecimalOdinsPawn():
		PieceType128("Odin's Pawn", "Pawn", "P", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WOthel.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BOthel.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 2000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_10x10 );
		SetSquareBonuses( 1, pawnSquareBonuses_10x10 );
		SetSquareBonuses( 2, pawnSquareBonuses_10x10 );
	}


	// *** OVERRIDES *** //
	virtual void PostPaintMoveDiagram( LPPAINTSTRUCT ps, HDC hdc );


	static DecimalOdinsPawn decimalOdinsPawn;
};

class DecimalOdinsKing:
	public PieceType128
{
  public:
	//	construction
	DecimalOdinsKing():
		PieceType128("Odin's King", "King", "K", 10, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType128::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_RUNES][0] = "images\\runes\\WAnsuz.bmp";
			bitmapFileNames[PIECE_SET_RUNES][1] = "images\\runes\\BAnsuz.bmp";
		}

		baseValue = 6000;
		SetSquareBonuses( 0, kingSquareBonuses_10x10 );
		SetSquareBonuses( 1, kingSquareBonuses_10x10 );
		SetSquareBonuses( 2, endgameKingSquareBonuses_10x10 );
	}

	static DecimalOdinsKing decimalOdinsKing;
};


#endif
