
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ODINS_RUNE_GAME_H
#define FILE__ODINS_RUNE_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"


//	***************************
//	**                       **
//	**     OdinsRuneGame     **
//	**                       **
//	***************************
//

class OdinsRuneGame:
	public Game
{
  protected:
	//	data members
	Piece *rooks[2][SET_SIZE];
	Piece *bishops[2][SET_SIZE];
	Piece *kings[2][SET_SIZE];
	Piece *oxen[2][SET_SIZE];
	Piece *valkyries[2][SET_SIZE];
	Piece *pawns[2][SET_SIZE];
	Piece *minorPieces[2][SET_SIZE];
	
	//	helper functions
	void AddMovesForForestOx
		( int currentPlayer, 
		  MovementList &list, 
		  int oxSquare,
		  bool quiescentSearch );

	void AddMovesForOdinsPawn
		( int currentPlayer, 
		  MovementList &list, 
		  int pawnSquare,
		  bool quiescentSearch );


  public:
	// *** INITIALIZATION *** //
	OdinsRuneGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );


	// *** OVERRIDES *** //
	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual void DescribeMove
		( MoveInfo &move,
		  char *queryDescription,
		  char *description,
		  char *notation );

	virtual void DescribeMove
		( Movement &movement,
		  char *description );

	virtual bool TestForWinLossDraw
		( int &eval );

	virtual int TranslateMove
		( MovementList &stack,
		  char *notation );

	virtual Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual void DeletePiece
		( Piece *piece );

	virtual void DefaultSettings();
};


#endif
