
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__UNICORN_CHESS_GAME_H
#define FILE__UNICORN_CHESS_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"


//	******************************
//	**                          **
//	**     UnicornChessGame     **
//	**                          **
//	******************************
//

class UnicornChessGame:
	public Game
{
  protected:
	//	data members
	Piece *rooks[2][SET_SIZE];
	Piece *knights[2][SET_SIZE];
	Piece *bishops[2][SET_SIZE];
	Piece *lions[2][SET_SIZE];
	Piece *unicorns[2][SET_SIZE];
	Piece *queens[2];
	Piece *chancellors[2][SET_SIZE];
	Piece *minorPieces[2][SET_SIZE];
	Piece *majorPieces[2][SET_SIZE];
	Piece *pawns[2][SET_SIZE];
	
	HashMap *enPassantHashMap;
	//	Zobrist keys which are x-or'ed into the board's primary hash
	//	for the current "en passant" square, if any

	word32 castlingHash0k;	//	\   Zobrist keys for castling privledge.
	word32 castlingHash0q;	//	 \_ these values are x-or'ed in if the
	word32 castlingHash1k;	//	 /  player has not lost the ability to
	word32 castlingHash1q;	//	/   castle on the given side.

	int variant;

	//	helper functions
	void InitializeBoard();

	//	variant information
	bool enPassant;			//	does this game have the en-passant rule?


	// *** OVERRIDES *** //
	virtual void AddPlayerPieceTypes();


  public:
	//	construction
	UnicornChessGame( Board &board, Player &whitePlayer, Player &blackPlayer );


	// *** OVERRIDES *** //
	virtual PieceType **GetPieceTypesRequired
		( int &nPieceTypes );

	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual word32 AdjustPrimaryHash
		( word32 primaryHash );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  PieceType **promotions );

	virtual Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual void DeletePiece
		( Piece *piece );
};


LRESULT CALLBACK UnicornChess_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam );


#endif
