
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../Resource.h"
#include "../../GameParameters.h"
#include "UnicornChessGame.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


LRESULT CALLBACK UnicornChess_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	char buffer[20];

	switch( Msg )
	{
	  case WM_INITDIALOG:
		::SendDlgItemMessage( hWndDlg, IDC_THINK_TIME_EDIT, WM_SETTEXT, (WPARAM) 0, (LPARAM) "20" );
		::SendDlgItemMessage( hWndDlg, IDC_OPENING_BOOK_CHECK, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		::SendDlgItemMessage( hWndDlg, IDC_UNICORN_GREAT_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		
		return TRUE;

	  case WM_COMMAND:
		switch(wParam)
		{
		  case IDOK:
			if( ::SendDlgItemMessage( hWndDlg, IDC_UNICORN_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Unicorn Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_UNICORN_GREAT_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Unicorn Great Chess" );	
			else if( ::SendDlgItemMessage( hWndDlg, IDC_UNICORN_GRAND_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Unicorn Grand Chess" );
			whiteComp = ::SendDlgItemMessage( hWndDlg, IDC_WHITE_COMPCONTROL, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			blackComp = ::SendDlgItemMessage( hWndDlg, IDC_BLACK_COMPCONTROL, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			useOpeningBook = SendDlgItemMessage( hWndDlg, IDC_OPENING_BOOK_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			::SendDlgItemMessage( hWndDlg, IDC_THINK_TIME_EDIT, WM_GETTEXT, (WPARAM) 18, (LPARAM) buffer );
			maxThinkTime = atoi( buffer );
			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		}
		break;
	}

	return FALSE;
}
