
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ANGELS_AND_DEVILS_GAME_H
#define FILE__ANGELS_AND_DEVILS_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"


//	*******************************
//	**                           **
//	**    AngelsAndDevilsGame    **
//	**                           **
//	*******************************
//

#include "Capablanca_Types.h"


class AngelsAndDevilsGame:
	public Game
{
  protected:
	//	data members
	HashMap *enPassantHashMap;
	//	Zobrist keys which are x-or'ed into the board's primary hash
	//	for the current "en passant" square, if any

	word32 castlingHash0k;	//	\   Zobrist keys for castling privledge.
	word32 castlingHash0q;	//	 \_ these values are x-or'ed in if the
	word32 castlingHash1k;	//	 /  player has not lost the ability to
	word32 castlingHash1q;	//	/   castle on the given side.

	BitBoard96 devilAttackMatrix[80];
	//	matrix of which squares, if containing a devil, will check 
	//	a White King on the square specified by the array index

	//	variant information
	bool enPassant;			//	does this game have the en-passant rule?


  public:
	// *** INITIALIZATION *** //
	AngelsAndDevilsGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void Initialize();

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );


	//	operations
	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual word32 AdjustPrimaryHash
		( word32 primaryHash );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  PieceType **promotions,
		  bool quiescentSearch );

	Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual bool IsInCheck( Piece *king );
};


#endif
