
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "Capablanca_Data.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


int openingPawnSquareBonuses_10x8[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20, -32, -60, -60, -32,  20,  20,  20, 
  -40, -40,  30,  20,  20,  20,  20,  30, -40, -40, 
  -40, -20,  22,  30,  80,  80,  30,  22, -20, -20, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,  60,  60, 160, 160,  60,  60,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0 
};

int pawnSquareBonuses_10x8[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20,   0, -60, -60,   0,  20,  20,  20, 
   20,  20,  30,  30,  20,  20,  30,  30,  20,  20, 
   30,  30,  20,  40, 200, 200,  40,  20,  30,  30, 
   40,  40,  60, 120, 180, 180, 120,  60,  40,  40, 
   70,  70,  60, 140, 200, 200, 140,  60,  70,  70, 
  100, 100,  60, 160, 240, 240, 160,  60, 100, 100, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

int bishopSquareBonuses_10x8[] = 
{
     -90,  -40,  -70,  -70,  -70,  -70,  -70,  -70,  -40,  -90
     -70,   30,   80,   30,   20,   20,   30,   80,   30,  -70,
     -70,    0,   40,  100,   60,   60,  100,   40,    0,  -70,
     -70,    0,   60,  140,  160,  160,  140,   60,    0,  -70,
     -70,    0,   60,  140,  160,  160,  140,   60,    0,  -70,
     -70,   10,   50,  120,   90,   90,  120,   50,   10,  -70,
     -70,   20,   15,   15,   15,   15,   15,   15,   20,  -70,
     -90,  -40,  -70,  -70,  -70,  -70,  -70,  -70,  -40,  -90
};

int knightSquareBonuses_10x8[] = 
{
	-200, -20, 140, 240, 260, 260, 240, 140, -20, -200,
	-540, -360, -80, 20, 100, 100, 20, -80, -360, -540,
	-440, -140, 140, 220, 320, 320, 220, 140, -140, -440,
	-400, -100, 160, 260, 360, 360, 260, 160, -100, -400,
	-420, -120, 140, 240, 340, 340, 240, 140, -120, -420,
	-500, -200, 80, 160, 260, 260, 160, 80, -200, -500,
	-640, -460, -180, -80, 0, 0, -80, -180, -460, -640,
	-780, -600, -440, -340, -320, -320, -340, -440, -600, -780
};

int queenSquareBonuses_10x8[] =
{
	-115,  -92,  -21,    1,    1,    1,    1,  -21,  -92, -115,
	-163, -115,  -52,  -13,   13,   13,  -13,  -52, -115, -163,
	-121,  -73,   -7,   25,   83,   83,   25,   -7,  -73, -121,
 	 -99,  -49,   17,   75,  108,  108,   75,   17,  -49,  -99,
	 -98,  -48,   18,   76,  109,  109,   76,   18,  -48,  -98,
	-118,  -70,   -4,   36,   86,   86,   28,   -4,  -70, -118,
	-158, -110,  -39,    8,   18,   18,   -8,  -47, -110, -158,
	-140, -117,  -46,  -24,  -24,  -24,  -24,  -46, -117, -140
};

int openingMajorPieceSquareBonuses_10x8[] =
{
     0,    0,   0,   0,   0,   0,   0,   0,    0,    0,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300,-300,-300, -300, -300
};

int rookSquareBonuses_10x8[] = 
{
	-82, -66, -10, 16, 24, 24, 16, -10, -66, -82,
	-102, -86, -30, -4, 4, 4, -4, -30, -86, -102,
	-54, -38, 2, 28, 36, 36, 28, 2, -38, -54,
	-50, -34, 6, 30, 38, 38, 30, 6, -34, -50,
	-49, -33, 7, 31, 39, 39, 31, 7, -33, -49,
	-51, -35, 5, 31, 39, 39, 31, 5, -35, -51,
	-97, -81, -25, 1, 9, 9, 1, -25, -81, -97,
	-97, -81, -25, 1, 9, 9, 1, -25, -81, -97
};

int openingArchbishopSquareBonuses_10x8[] = 
{
	59, 83, 96, 74, 50, 50, 74, 96, 83, 59,
	-81, -15, 3, -2, 73, 73, -2, 3, -15, -81,
	-113, -17, 56, 21, 168, 168, 21, 56, -17, -113,
	-113, -30, 18, 67, 134, 134, 67, 18, -30, -113,
	-116, -33, 15, 64, 131, 131, 64, 15, -33, -116,
	-122, -26, 47, 37, 159, 159, 12, 47, -26, -122,
	-96, -30, 13, 33, 58, 58, -17, -12, -30, -96,
	-76, -52, -39, -61, -85, -85, -61, -39, -52, -76
};

int archbishopSquareBonuses_10x8[] = 
{
	   9,   33,  46,  24,   0,   0,  24,  46,  33,    9,
	 -81,  -15,   3,  -2,  73,  73,  -2,   3, -15,  -81,
	-113,  -17,  56,  21, 168, 168,  21,  56, -17, -113,
	-113,  -30,  18,  67, 134, 134,  67,  18, -30, -113,
	-116,  -33,  15,  64, 131, 131,  64,  15, -33, -116,
	-122,  -26,  47,  37, 159, 159,  12,  47, -26, -122,
	 -96,  -30,  13,  33,  58,  58, -17, -12, -30,  -96,
	 -76,  -52, -39, -61, -85, -85, -61, -39, -52,  -76
};

int chancellorSquareBonuses_10x8[] = 
{
	-142, -110,  -48,  14,  26,  26,  14, -48, -110, -142,
	-144, -112,  -38,  24,  52,  52,  24, -38, -112, -144,
	-106,  -62,    0,  52,  90,  90,  52,   0,  -62, -106,
	 -60,  -16,   36,  78, 102, 102,  78,  36,  -16,  -60,
	 -57,  -13,   39,  81, 105, 105,  81,  39,  -13,  -57,
	 -97,  -53,    9,  61,  99,  99,  61,   9,  -53,  -97,
	-129,  -97,  -23,  39,  67,  67,  39, -23,  -97, -129,
	-137, -105,  -43,  19,  31,  31,  19, -43, -105, -137
};

int kingSquareBonuses_10x8[] =
{
   240, 240, 240, 160, 160, 160, 160, 240, 320, 320,
   240, 200, 160, 120, 120, 120, 120, 160, 200, 240,
   160, 120,  80,  40,  40,  40,  40,  80, 120, 160,
   120,  80,  40,   0,   0,   0,   0,  40,  80, 120,
    60,   0,   0,   0,   0,   0,   0,   0,   0,  60,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

int endgameKingSquareBonuses_10x8[] =
{
    0,  60, 120, 180, 180, 180, 180, 120,  60,   0,
   60, 120, 180, 240, 240, 240, 240, 180, 120,  60,
  120, 180, 240, 320, 320, 320, 320, 240, 180, 120,
  180, 240, 320, 480, 480, 480, 480, 320, 240, 180,
  180, 240, 320, 480, 480, 480, 480, 320, 240, 180,
  120, 180, 240, 320, 320, 320, 320, 240, 180, 120,
   60, 120, 180, 240, 240, 240, 240, 180, 120,  60,
    0,  60, 120, 180, 180, 180, 180, 120,  60,   0
};

int genericSmallCenterBonuses_10x8[] =
{
   -30,  -30,  -30, -30,  -30,  -30,  -30,  -30,  -30,  -30,
   -30,    0,    0,   0,    0,    0,    0,    0,    0,  -30,
   -30,    0,   30,  30,   40,   40,   30,   30,    0,  -30,
   -30,    0,   30,  60,   80,   80,   60,   30,    0,  -30,
   -30,    0,   30,  60,   80,   80,   60,   30,    0,  -30,
   -30,    0,   30,  30,   40,   40,   30,   30,    0,  -30,
   -30,    0,    0,   0,   20,   20,    0,    0,    0,  -30,
   -80,  -60,  -60, -60,  -60,  -60,  -60,  -60,  -60,  -80
};

int genericLargeCenterBonuses_10x8[] =
{
   -90,  -70,  -70,  -70,  -70,  -70,  -70,  -70,  -70,  -90,
   -70,    0,    0,    0,    0,    0,    0,    0,    0,  -70,
   -70,    0,   30,   50,   60,   60,   50,   30,    0,  -70,
   -70,    0,   60,  140,  160,  160,  140,   60,    0,  -70,
   -70,    0,   70,  140,  160,  160,  140,   70,    0,  -70,
   -70,    0,   50,   80,   90,   90,   80,   50,    0,  -70,
   -70,    0,   15,   15,   15,   15,   15,   15,    0,  -70,
   -90,  -70,  -70,  -70,  -70,  -70,  -70,  -70,  -70,  -90
};

//	values for posted pieces...
//	IMPORTANT: don't put non-zero values
//	on the left-most or right-most files!
//	the outpost code checks for pawns to
//	the left and right, and it doesn't 
//	check to make sure that's not off the
//	edge of the board!
//	you wouldn't want an outpost on the
//	rim anyway; it's not worth a bonus
int outpost_10x8[] = 
{
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   2,   5,  10,  10,   5,   2,   0,   0,
    0,   0,   3,   6,  12,  12,   6,   3,   0,   0,
    0,   0,   0,   6,  12,  12,   6,   0,   0,   0,
    0,   0,   0,   2,   5,   5,   2,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};
