
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../Resource.h"
#include "CapablancaGame.h"
#include "CapablancaSelectDialog.h"
#include "../../GameParameters.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


static HWND hSubDialog;
SCustomCapablancaInfo customInfo;


LRESULT CALLBACK Capablanca_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	switch( Msg )
	{
	  case WM_INITDIALOG:
		{
			if( !strcmp( gameSelection, "Carrera's Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_CARRERA, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Bird's Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_BIRD, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Carrera's Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_CARRERA, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Capablanca Chess, Aberg variant" ) )
				::SendDlgItemMessage( hWndDlg, IDC_ABERG, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Capablanca Chess, Paulowich variant" ) )
				::SendDlgItemMessage( hWndDlg, IDC_PAULOWICH, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Grotesque Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_GROTESQUE, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Ladorean Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_LADOREAN, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Univers Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_UNIVERS, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Schoolbook Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_SCHOOLBOOK, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( !strcmp( gameSelection, "Embassy Chess" ) )
				::SendDlgItemMessage( hWndDlg, IDC_EMBASSY, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else
				::SendDlgItemMessage( hWndDlg, IDC_CAPABLANCA, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			
			return TRUE;
		}

	  case WM_COMMAND:
		switch(wParam)
		{
		  case IDOK:
			customInfo.twoSpacePawnMove = true;
			customInfo.enPassant = true;
			customInfo.shatranjReplacement = false;
			customInfo.chancellorNotation = 'C';
			customInfo.archbishopNotation = 'A';
			if( ::SendDlgItemMessage( hWndDlg, IDC_CAPABLANCA, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_STANDARD;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.array = "rnabqkbcnr/pppppppppp/10/10/10/10/PPPPPPPPPP/RNABQKBCNR";
				strcpy( gameSelection, "Capablanca Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_BIRD, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_STANDARD;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'G';
				customInfo.archbishopNotation = 'E';
				customInfo.array = "rnbcqkabnr/pppppppppp/10/10/10/10/PPPPPPPPPP/RNBCQKABNR";
				strcpy( gameSelection, "Bird's Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CARRERA, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_MAJORS;
				customInfo.castlingRule = CASTLING_TYPE_NONE;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'C';
				customInfo.archbishopNotation = 'E';
				customInfo.array = "rcnbkqbnar/pppppppppp/10/10/10/10/PPPPPPPPPP/RCNBKQBNAR";
				strcpy( gameSelection, "Carrera's Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ABERG, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_FREE;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.array = "ranbqkbncr/pppppppppp/10/10/10/10/PPPPPPPPPP/RANBQKBNCR";
				strcpy( gameSelection, "Capablanca Chess, Aberg variant" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_PAULOWICH, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_MAJORS;
				customInfo.castlingRule = CASTLING_TYPE_CLOSE_ROOK;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.array = "crnbakbnrq/pppppppppp/10/10/10/10/PPPPPPPPPP/CRNBAKBNRQ";
				strcpy( gameSelection, "Capablanca Chess, Paulowich variant" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_GROTESQUE, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_FLEXIBLE;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'G';
				customInfo.archbishopNotation = 'E';
				customInfo.array = "rbqnkcnabr/pppppppppp/10/10/10/10/PPPPPPPPPP/RBQNKCNABR";
				strcpy( gameSelection, "Grotesque Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_LADOREAN, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_FLEXIBLE;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'M';
				customInfo.archbishopNotation = 'C';
				customInfo.array = "rbqnkancbr/pppppppppp/10/10/10/10/PPPPPPPPPP/RBQNKANCBR";
				strcpy( gameSelection, "Ladorean Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_UNIVERS, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_FLEXIBLE;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'M';
				customInfo.archbishopNotation = 'A';
				customInfo.array = "rbncqkanbr/pppppppppp/10/10/10/10/PPPPPPPPPP/RBNCQKANBR";
				strcpy( gameSelection, "Univers Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SCHOOLBOOK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_FLEXIBLE;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'M';
				customInfo.archbishopNotation = 'A';
				customInfo.array = "rqnbakbnCr/pppppppppp/10/10/10/10/PPPPPPPPPP/RQNBAKBNCR";
				strcpy( gameSelection, "Schoolbook Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_EMBASSY, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_STANDARD;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.chancellorNotation = 'M';
				customInfo.archbishopNotation = 'C';
				customInfo.array = "rnbqkcabnr/pppppppppp/10/10/10/10/PPPPPPPPPP/RNBQKCABNR";
				strcpy( gameSelection, "Embassy Chess" );
			}
			else if( ::SendDlgItemMessage( hWndDlg, IDC_OPTI, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				customInfo.promotionRule = PAWN_PROMOTION_TYPE_STANDARD;
				customInfo.castlingRule = CASTLING_TYPE_USER_CASTLING_1;
				customInfo.includeChancellor = true;
				customInfo.includeArchbishop = true;
				customInfo.array = "nrcbqkbarn/pppppppppp/10/10/10/10/PPPPPPPPPP/NRCBQKBARN";
				strcpy( gameSelection, "Opti Chess (mirror I)" );
			}
			if( ::SendDlgItemMessage( hWndDlg, IDC_CUSTOMIZE_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				int rtn = (int) ::DialogBox( theInstance, MAKEINTRESOURCE(IDD_CUSTOMIZE_CAPABLANCA_DIALOG), hWndDlg, (DLGPROC) CustomizeCapablancaDlgProc );
			}
			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		}
		break;
	}

	return FALSE;
}

int defaultCastlingTypeComboID;
static char array[80];

void ReplaceCharInString
	( char *string, 
	  char find,
	  char replace )
{
	int len = (int) strlen( string );
	for( int x = 0; x < len; x++ )
		if( string[x] == find )
			string[x] = replace;
}

bool IsCharInString
	( char *string,
	  char find )
{
	int len = (int) strlen( string );
	for( int x = 0; x < len; x++ )
		if( string[x] == find )
			return true;
	return false;
}

LRESULT CALLBACK CustomizeCapablancaDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	switch( Msg )
	{
	  case WM_INITDIALOG:
		{
			if( customInfo.twoSpacePawnMove )
				::SendDlgItemMessage( hWndDlg, IDC_2_SPACE_PAWN, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			if( customInfo.enPassant )
				::SendDlgItemMessage( hWndDlg, IDC_EN_PASSANT, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			if( customInfo.promotionRule == PAWN_PROMOTION_TYPE_STANDARD )
				::SendDlgItemMessage( hWndDlg, IDC_STANDARD_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else if( customInfo.promotionRule == PAWN_PROMOTION_TYPE_MAJORS )
				::SendDlgItemMessage( hWndDlg, IDC_MAJORS_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			else
				::SendDlgItemMessage( hWndDlg, IDC_QUEEN_ONLY_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			::EnableWindow( ::GetDlgItem( hWndDlg, IDC_STANDARD_RADIO ), false );
			::EnableWindow( ::GetDlgItem( hWndDlg, IDC_MAJORS_RADIO ), false );
			::EnableWindow( ::GetDlgItem( hWndDlg, IDC_QUEEN_ONLY_RADIO ), false );
			//	castling types
			int indexToSelect = -1;
			int indexInserted;
			indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "none" );
			if( customInfo.castlingRule == CASTLING_TYPE_NONE )
				indexToSelect = indexInserted;
			indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "standard" );
			if( customInfo.castlingRule == CASTLING_TYPE_STANDARD )
				indexToSelect = indexInserted;
			indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "long" );
			if( customInfo.castlingRule == CASTLING_TYPE_LONG )
				indexToSelect = indexInserted;
			indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "close-rook" );
			if( customInfo.castlingRule == CASTLING_TYPE_CLOSE_ROOK )
				indexToSelect = indexInserted;
			indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "flexible" );
			if( customInfo.castlingRule == CASTLING_TYPE_FLEXIBLE )
				indexToSelect = indexInserted;
			indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "free" );
			if( customInfo.castlingRule == CASTLING_TYPE_FREE )
				indexToSelect = indexInserted;
			if( customInfo.castlingRule == CASTLING_TYPE_USER_CASTLING_1 )
			{
				indexInserted = (int) ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_ADDSTRING, 0, (LPARAM) "custom" );
				indexToSelect = indexInserted;
			}
			ASSERT(indexToSelect >= 0 );
			defaultCastlingTypeComboID = indexToSelect;
			::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_SETCURSEL, (WPARAM) defaultCastlingTypeComboID, (LPARAM) 0 );
			::EnableWindow( ::GetDlgItem( hWndDlg, IDC_CASTLING_TYPE_COMBO ), false );
			if( customInfo.includeChancellor )
				::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_CHANCELLOR, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			if( customInfo.includeArchbishop )
				::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_ARCHBISHOP, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
			::SetWindowText( ::GetDlgItem( hWndDlg, IDC_ARRAY_EDIT ), customInfo.array );
			::EnableWindow( ::GetDlgItem( hWndDlg, IDC_ARRAY_EDIT ), false );
		}
		break;

	  case WM_COMMAND:
		{
			if( HIWORD(wParam) == BN_CLICKED )
			{
				int id = LOWORD(wParam);
				if( id == IDC_CHANGE_CASTLING_RULE )
				{
					if( ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_CASTLING_RULE, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
					{
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_CASTLING_TYPE_COMBO ), true );
					}
					else
					{
						::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, (UINT) CB_SETCURSEL, (WPARAM) defaultCastlingTypeComboID, (LPARAM) 0 );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_CASTLING_TYPE_COMBO ), false );
					}
					return TRUE;
				}
				else if( id == IDC_2_SPACE_PAWN )
				{
					if( ::SendDlgItemMessage( hWndDlg, IDC_2_SPACE_PAWN, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
					{
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_EN_PASSANT ), true );
						::SendDlgItemMessage( hWndDlg, IDC_EN_PASSANT, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
					}
					else
					{
						::SendDlgItemMessage( hWndDlg, IDC_EN_PASSANT, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_EN_PASSANT  ), false );
					}
					return TRUE;
				}
				else if( id == IDC_CHANGE_PAWN_PROMOTION_RULE )
				{
					if( ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_PAWN_PROMOTION_RULE, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
					{
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_STANDARD_RADIO ), true );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_MAJORS_RADIO ), true );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_QUEEN_ONLY_RADIO ), true );
					}
					else
					{
						if( customInfo.promotionRule == PAWN_PROMOTION_TYPE_STANDARD )
						{
							::SendDlgItemMessage( hWndDlg, IDC_STANDARD_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
							::SendDlgItemMessage( hWndDlg, IDC_MAJORS_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
							::SendDlgItemMessage( hWndDlg, IDC_QUEEN_ONLY_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
						}
						else if( customInfo.promotionRule == PAWN_PROMOTION_TYPE_MAJORS )
						{
							::SendDlgItemMessage( hWndDlg, IDC_MAJORS_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
							::SendDlgItemMessage( hWndDlg, IDC_STANDARD_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
							::SendDlgItemMessage( hWndDlg, IDC_QUEEN_ONLY_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
						}
						else
						{
							::SendDlgItemMessage( hWndDlg, IDC_QUEEN_ONLY_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
							::SendDlgItemMessage( hWndDlg, IDC_STANDARD_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
							::SendDlgItemMessage( hWndDlg, IDC_MAJORS_RADIO, BM_SETCHECK, (WPARAM) 0, (LPARAM) 0 );
						}
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_STANDARD_RADIO ), false );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_MAJORS_RADIO ), false );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_QUEEN_ONLY_RADIO ), false );
					}
					return TRUE;
				}
				else if( id == IDC_CHANGE_STARTING_ARRAY )
				{
					if( ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_STARTING_ARRAY, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
					{
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_ARRAY_EDIT ), true );
					}
					else
					{
						::SetWindowText( ::GetDlgItem( hWndDlg, IDC_ARRAY_EDIT ), customInfo.array );
						::EnableWindow( ::GetDlgItem( hWndDlg, IDC_ARRAY_EDIT ), false );
					}
					return TRUE;
				}
				else if( id == IDOK )
				{
					bool everythingOk = true;
					bool somethingHasBeenChanged = false;
					//	verify contents of array
					::GetWindowText( ::GetDlgItem( hWndDlg, IDC_ARRAY_EDIT ), array, 80 );
					int len = (int) strlen( array );
					char *validChars = new char[40];
					strcpy( validChars, "RNBKQPrnbkqp/0123456789" );
					if( ::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_ARCHBISHOP, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
						sprintf( validChars, "%s%s", validChars, "Aa" );
					if( ::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_CHANCELLOR, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
						sprintf( validChars, "%s%s", validChars, "Cc" );
					for( int x = 0; x < len; x++ )
						if( !IsCharInString( validChars, array[x] ) )
							everythingOk = false;
					delete[] validChars;
					if( !everythingOk )
					{
						::MessageBox( hWndDlg, "The opening array you have entered\ndoes not appear to be valid.", "Error in Array", 
							MB_ICONHAND | MB_OK );
					}
					else
					{
						if( ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_STARTING_ARRAY, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
						{
							if( ::SendDlgItemMessage( hWndDlg, IDC_SHATRANJ_TYPE_BY_CBJ_CHECK, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
							{
								ReplaceCharInString( array, 'C', 'M' );
								ReplaceCharInString( array, 'c', 'm' );
								ReplaceCharInString( array, 'A', 'H' );
								ReplaceCharInString( array, 'a', 'h' );
								StoreParameter( "array", array );
							}
							else
							{
								ReplaceCharInString( array, 'C', customInfo.chancellorNotation );
								ReplaceCharInString( array, 'c', tolower( customInfo.chancellorNotation ) );
								ReplaceCharInString( array, 'A', customInfo.archbishopNotation );
								ReplaceCharInString( array, 'a', tolower( customInfo.archbishopNotation ) );
								StoreParameter( "array", array );
								somethingHasBeenChanged = true;
							}
						}
					}
					if( everythingOk )
					{
						if( ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_CASTLING_RULE, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
						{
							int selection = ::SendDlgItemMessage( hWndDlg, IDC_CASTLING_TYPE_COMBO, CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0 );
							if( selection == 0 )
							{
								if( customInfo.castlingRule != CASTLING_TYPE_NONE )
								{
									StoreParameter( "castling-type", "none" );
									somethingHasBeenChanged = true;
								}
							}
							else if( selection == 1 )
							{
								if( customInfo.castlingRule != CASTLING_TYPE_STANDARD )
								{
									StoreParameter( "castling-type", "standard" );
									somethingHasBeenChanged = true;
								}
							}
							else if( selection == 2 )
							{
								if( customInfo.castlingRule != CASTLING_TYPE_LONG )
								{
									StoreParameter( "castling-type", "long" );
									somethingHasBeenChanged = true;
								}
							}
							else if( selection == 3 )
							{
								if( customInfo.castlingRule != CASTLING_TYPE_CLOSE_ROOK )
								{
									StoreParameter( "castling-type", "close-rook" );
									somethingHasBeenChanged = true;
								}
							}
							else if( selection == 4 )
							{
								if( customInfo.castlingRule != CASTLING_TYPE_FLEXIBLE )
								{
									StoreParameter( "castling-type", "flexible" );
									somethingHasBeenChanged = true;
								}
							}
							else if( selection == 5 )
							{
								if( customInfo.castlingRule != CASTLING_TYPE_FREE )
								{
									StoreParameter( "castling-type", "free" );
									somethingHasBeenChanged = true;
								}
							}
						}
						if( ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_PAWN_PROMOTION_RULE, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
						{
							if( ::SendDlgItemMessage( hWndDlg, IDC_STANDARD_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED && 
								customInfo.promotionRule != PAWN_PROMOTION_TYPE_STANDARD )
							{
								StoreParameter( "pawn-promotion-type", "standard" );
								somethingHasBeenChanged = true;
							}
							else if( ::SendDlgItemMessage( hWndDlg, IDC_MAJORS_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED && 
								customInfo.promotionRule != PAWN_PROMOTION_TYPE_MAJORS )
							{
								StoreParameter( "pawn-promotion-type", "majors" );
								somethingHasBeenChanged = true;
							}
							else if( ::SendDlgItemMessage( hWndDlg, IDC_QUEEN_ONLY_RADIO, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED && 
								customInfo.promotionRule != PAWN_PROMOTION_TYPE_QUEEN )
							{
								StoreParameter( "pawn-promotion-type", "queen" );
								somethingHasBeenChanged = true;
							}
						}
						if( ::SendDlgItemMessage( hWndDlg, IDC_2_SPACE_PAWN, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) != BST_CHECKED )
						{
							QueueRemovePieceTypeFunctionCall( "Pawn" );
							QueueAddPieceTypeFunctionCall( "Lame Pawn" );
							somethingHasBeenChanged = true;
						}
						if( ::SendDlgItemMessage( hWndDlg, IDC_EN_PASSANT, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) != BST_CHECKED )
						{
							StoreParameter( "en-passant", false );
							somethingHasBeenChanged = true;
						}
						if( ::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_CHANCELLOR, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) != BST_CHECKED && 
							customInfo.includeChancellor )
						{
							QueueRemovePieceTypeFunctionCall( "Chancellor" );
							somethingHasBeenChanged = true;
						}
						if( ::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_ARCHBISHOP, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) != BST_CHECKED && 
							customInfo.includeArchbishop )
						{
							QueueRemovePieceTypeFunctionCall( "Archbishop" );
							somethingHasBeenChanged = true;
						}
						if( ::SendDlgItemMessage( hWndDlg, IDC_SHATRANJ_TYPE_BY_CBJ_CHECK, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
						{
							if( ::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_ARCHBISHOP, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
							{
								QueueRemovePieceTypeFunctionCall( "Archbishop" );
								QueueAddPieceTypeFunctionCall( "High Priestess" );
								somethingHasBeenChanged = true;
							}
							if( ::SendDlgItemMessage( hWndDlg, IDC_INCLUDE_CHANCELLOR, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) == BST_CHECKED )
							{
								QueueRemovePieceTypeFunctionCall( "Chancellor" );
								QueueAddPieceTypeFunctionCall( "Minister" );
								somethingHasBeenChanged = true;
							}
							if( somethingHasBeenChanged && ::SendDlgItemMessage( hWndDlg, IDC_CHANGE_STARTING_ARRAY, BM_GETCHECK, (WPARAM) 0, (LPARAM) 0 ) != BST_CHECKED )
							{
								strcpy( array, customInfo.array );
								ReplaceCharInString( array, 'A', 'H' );
								ReplaceCharInString( array, 'a', 'h' );
								ReplaceCharInString( array, 'C', 'M' );
								ReplaceCharInString( array, 'c', 'm' );
								StoreParameter( "array", array );
							}
						}
						if( somethingHasBeenChanged )
						{
							StoreParameter( "use-opening-book", false );
							if( ::MessageBox( hWndDlg, "Do you wish to add this game to ChessV\nas a new variant?", "Save Variant",
								MB_ICONQUESTION | MB_YESNO ) == IDYES )
							{
								saveNewVariant = true;
							}
						}
						::EndDialog( hWndDlg, IDOK );
						return TRUE;
					}
				}
			}
		}
		break;
	}

	return FALSE;
}
