
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__CAPABLANCA_TYPES_H
#define FILE__CAPABLANCA_TYPES_H


#include "../../Personality.h"
#include "../../PieceType.h"
#include "Capablanca_Data.h"


class CapablancaRook:
	public PieceType96
{
  public:
	//	construction
	CapablancaRook():
		PieceType96("Rook", "Rook", "R", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		optimization = SimpleSlider;
		if( personality >= PERSONALITY_C )
		{
			baseValue = 5500;
		}
		else
		{
			baseValue = 5000;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
		}

		SetSquareBonuses( 0, rookSquareBonuses_10x8 );
		SetSquareBonuses( 1, rookSquareBonuses_10x8 );
		SetSquareBonuses( 2, rookSquareBonuses_10x8 );
		SetMobility( AutomaticBitboardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -9 );
		SetTropism( 7, -10 );
		SetTropism( 8, -10 );
		SetTropism( 9, -10 );
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static CapablancaRook capablancaRook;
};

class CapablancaBishop:
	public PieceType96
{
  public:
	//	construction
	CapablancaBishop():
		PieceType96("Bishop", "Bishop", "B", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3500;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 3500;
			perCaptureValueBonus = 25;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, bishopSquareBonuses_10x8 );
			SetSquareBonuses( 1, bishopSquareBonuses_10x8 );
			SetSquareBonuses( 2, bishopSquareBonuses_10x8 );
		}

		SetMobility( AutomaticBitboardMobility, -8, 24 );
		SetTropismType( DistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -1 );
		SetTropism( 3, -3 );
		SetTropism( 4, -5 );
		SetTropism( 5, -7 );
		SetTropism( 6, -7 );
		SetTropism( 7, -7 );
		optimization = SimpleSlider;
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static CapablancaBishop capablancaBishop;
};

class CapablancaKnight:
	public PieceType96
{
  public:
	//	construction
	CapablancaKnight():
		PieceType96("Knight", "Knight", "N", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		optimization = SimpleSingleStep;
		if( personality >= PERSONALITY_C )
		{
			baseValue = 2750;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 2800;
			SetSquareBonuses( 0, knightSquareBonuses_10x8 );
			SetSquareBonuses( 1, knightSquareBonuses_10x8 );
			SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaKnight capablancaKnight;
};

class CapablancaQueen:
	public PieceType96
{
  public:
	//	construction
	CapablancaQueen():
		PieceType96("Queen", "Queen", "Q", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		optimization = SimpleSlider;
		if( personality >= PERSONALITY_C )
		{
			baseValue = 9750;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 9000;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 12;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, queenSquareBonuses_10x8 );
			SetSquareBonuses( 2, queenSquareBonuses_10x8 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaQueen capablancaQueen;
};

class CapablancaKing:
	public PieceType96
{
  public:
	//	construction
	CapablancaKing():
		PieceType96("King", "King", "K", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}
		baseValue = 25000;
		SetSquareBonuses( 0, kingSquareBonuses_10x8 );
		SetSquareBonuses( 1, kingSquareBonuses_10x8 );
		SetSquareBonuses( 2, endgameKingSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
		isRoyal = true;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaKing capablancaKing;
};

class CapablancaPawn:
	public PieceType96
{
  public:
	//	construction
	CapablancaPawn():
		PieceType96("Pawn", "Pawn", "P", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 2, MoveOnly, 0, 19 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly, 20, 79 ) );
		}
		baseValue = 1000;
		perCaptureValueBonus = 60;
		perCaptureBonusThreshold = 15;
		SetSquareBonuses( 0, openingPawnSquareBonuses_10x8 );
		SetSquareBonuses( 1, pawnSquareBonuses_10x8 );
		SetSquareBonuses( 2, pawnSquareBonuses_10x8 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		promotion.SetTypeToPromoteTo( CapablancaQueen::capablancaQueen );
		isPawn = true;
	}

	virtual void BB96_Initialize()
	{
		//	call base class's BB96_Initialize function
		PieceType96::BB96_Initialize();

		//	now add the single-step non-capturing move from the
		//	starting rank; the two-step move will be handled specially by
		//	CapablancaGame::GenerateMoves()
		for( int x = 0; x < 10; x++ )
		{
			bb96_direct_move_no_capture[0][x+10].SetBit( x + 20 );
			bb96_direct_move_no_capture[1][x+60].SetBit( x + 50 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaPawn capablancaPawn;
};

class CapablancaLamePawn:
	public PieceType96
{
  public:
	//	construction
	CapablancaLamePawn():
		PieceType96("Lame Pawn", "Pawn", "P", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly ) );
		}
		baseValue = 1000;
		SetSquareBonuses( 0, openingPawnSquareBonuses_10x8 );
		SetSquareBonuses( 1, pawnSquareBonuses_10x8 );
		SetSquareBonuses( 2, pawnSquareBonuses_10x8 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		promotion.SetTypeToPromoteTo( CapablancaQueen::capablancaQueen );
		isPawn = true;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaLamePawn capablancaLamePawn;
};

class CapablancaArchbishop:
	public PieceType96
{
  public:
	//	construction
	CapablancaArchbishop():
		PieceType96("Archbishop", "Archbishop", "A", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCardinal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCardinal2.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCardinal.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCardinal.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WArchbishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BArchbishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 7750;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 7500;
			perCaptureValueBonus = 25;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingArchbishopSquareBonuses_10x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_10x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_10x8 );
		}

		SetMobility( AutomaticBitboardMobility, -6, 12 );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaArchbishop capablancaArchbishop;
};

class CapablancaChancellor:
	public PieceType96
{
  public:
	//	construction
	CapablancaChancellor():
		PieceType96("Chancellor", "Chancellor", "C", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WMarshal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BMarshal2.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9500;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 8500;
			perCaptureValueBonus = 65;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8);
			SetSquareBonuses( 1, chancellorSquareBonuses_10x8 );
			SetSquareBonuses( 2, chancellorSquareBonuses_10x8 );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaChancellor capablancaChancellor;
};

class CapablancaDragonKing:
	public PieceType96
{
  public:
	//	construction
	CapablancaDragonKing():
		PieceType96("Dragon King", "Dragon King", "_DK", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPromotedRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPromotedRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 7000;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 6500;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8);
			SetSquareBonuses( 1, chancellorSquareBonuses_10x8 );
			SetSquareBonuses( 2, chancellorSquareBonuses_10x8 );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 6 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaDragonKing capablancaDragonKing;
};

class CapablancaDragonHorse:
	public PieceType96
{
  public:
	//	construction
	CapablancaDragonHorse():
		PieceType96("Dragon Horse", "Dragon Horse", "_DH", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPromotedBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPromotedBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6500;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 5750;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 8;
			SetSquareBonuses( 0, openingArchbishopSquareBonuses_10x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_10x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_10x8 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 6 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaDragonHorse capablancaDragonHorse;
};

class CapablancaTower:
	public PieceType96
{
  public:
	//	construction
	CapablancaTower():
		PieceType96("Tower", "Tower", "T", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamelRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamelRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9000;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 8250;
			perCaptureValueBonus = 65;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8);
			SetSquareBonuses( 1, chancellorSquareBonuses_10x8 );
			SetSquareBonuses( 2, chancellorSquareBonuses_10x8 );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaTower capablancaTower;
};

class CapablancaSage:
	public PieceType96
{
  public:
	//	construction
	CapablancaSage():
		PieceType96("Sage", "Sage", "S", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamelBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamelBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6500;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 6250;
			perCaptureValueBonus = 25;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingArchbishopSquareBonuses_10x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_10x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_10x8 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaSage capablancaSage;
};

class CapablancaUnicorn:
	public PieceType96
{
  public:
	//	construction
	CapablancaUnicorn():
		PieceType96("Unicorn", "Unicorn", "U", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WUnicorn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BUnicorn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WNightPrincess.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BNightPrincess.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 0 ) );
			AddMovementCapability( MovementCapability(  1,  2, 0 ) );
			AddMovementCapability( MovementCapability( -2,  1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 0 ) );
			AddMovementCapability( MovementCapability(  1, -2, 0 ) );
			AddMovementCapability( MovementCapability( -2, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2, -1, 0 ) );
		}

		baseValue = 9350;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			SetSquareBonuses( 0, queenSquareBonuses_10x8 );
			SetSquareBonuses( 1, queenSquareBonuses_10x8 );
			SetSquareBonuses( 2, queenSquareBonuses_10x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaUnicorn capablancaUnicorn;
};

class CapablancaLion:
	public PieceType96
{
  public:
	//	construction
	CapablancaLion():
		PieceType96("Half-Duck", "Lion", "L", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLion.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WHalfDuck.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BHalfDuck.bmp";
			AddMovementCapability( MovementCapability(  0,  3, 1 ) );
			AddMovementCapability( MovementCapability(  3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 5000;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaLion capablancaLion;
};

class CapablancaWildebeest:
	public PieceType96
{
  public:
	//	construction
	CapablancaWildebeest():
		PieceType96("Wildebeest", "Wildebeest", "W", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWildebeest.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWildebeest.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		optimization = SimpleSingleStep;
		if( personality >= PERSONALITY_C )
		{
			baseValue = 5750;
			SetSquareBonuses( 0, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_10x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_10x8 );
		}
		else
		{
			baseValue = 5500;
			SetSquareBonuses( 0, knightSquareBonuses_10x8 );
			SetSquareBonuses( 1, knightSquareBonuses_10x8 );
			SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaWildebeest capablancaWildebeest;
};

class CapablancaAngel:
	public PieceType96
{
  public:
	//	construction
	CapablancaAngel():
		PieceType96("Angel", "Angel", "A", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WAngel.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BAngel.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WAngel.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BAngel.bmp";
		}

		baseValue = 6750;
	}

	static CapablancaAngel capablancaAngel;
};

class CapablancaDevil:
	public PieceType96
{
  public:
	//	construction
	CapablancaDevil():
		PieceType96("Devil", "Devil", "D", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WDevil.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDevil.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WDevil.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BDevil.bmp";
		}

		baseValue = 6750;
	}

	static CapablancaDevil capablancaDevil;
};


class CapablancaGeneral:
	public PieceType96
{
  public:
	//	construction
	CapablancaGeneral():
		PieceType96("General", "General", "G", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WGuard.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGeneral.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGeneral.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WGuard.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		}

		baseValue = 3200;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaGeneral capablancaGeneral;
};


class CapablancaKnightGeneral:
	public PieceType96
{
  public:
	//	construction
	CapablancaKnightGeneral():
		PieceType96("Knight-General", "General", "G", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawnKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawnKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WGeneral.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BGeneral.bmp";
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 6250;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaKnightGeneral capablancaKnightGeneral;
};


class CapablancaElephantFerz:
	public PieceType96
{
  public:
	//	construction
	CapablancaElephantFerz():
		PieceType96("Elephant-Ferz", "Elephant", "E", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephantFerz.bmp";
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		}

		baseValue = 2250;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaElephantFerz capablancaElephantFerz;
};


class CapablancaWoodyRook:
	public PieceType96
{
  public:
	//	construction
	CapablancaWoodyRook():
		PieceType96("Woody Rook", "Woody Rook", "_WR", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWarMachineWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWarMachineWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWoodyRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWoodyRook.bmp";
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
		}

		baseValue = 2300;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaWoodyRook capablancaWoodyRook;
};


class CapablancaMinister:
	public PieceType96
{
  public:
	//	construction
	CapablancaMinister():
		PieceType96("Minister", "Minister", "M", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\Wnwd.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\Bnwd.bmp";
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 5500;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaMinister capablancaMinister;
};


class CapablancaHighPriestess:
	public PieceType96
{
  public:
	//	construction
	CapablancaHighPriestess():
		PieceType96("High Priestess", "High Priestess", "H", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WHighPriestess.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BHighPriestess.bmp";
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 5500;
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		optimization = SimpleSingleStep;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaHighPriestess capablancaHighPriestess;
};
/*
class CapablancaFalcon:
	public PieceType96
{
  public:
	//	construction
	CapablancaFalcon():
		PieceType96("Falcon", "Falcon", "F", 8, 10)
		{
		}

	virtual void Initialize()
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBird.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBird.bmp";
		}
		SetSquareBonuses( 0, knightSquareBonuses_10x8 );
		SetSquareBonuses( 1, knightSquareBonuses_10x8 );
		SetSquareBonuses( 2, knightSquareBonuses_10x8 );
		baseValue = 5500;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static CapablancaFalcon capablancaFalcon;
};
*/
#endif
