
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__12x8_TYPES_H
#define FILE__12x8_TYPES_H


#include "../../Personality.h"
#include "12x8_Data.h"


class Rook_12x8:
	public PieceType96
{
  public:
	//	construction
	Rook_12x8():
		PieceType96("Rook", "Rook", "R", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6000;
		}
		else
		{
			baseValue = 5500;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 15;
		}

		SetSquareBonuses( 0, rookSquareBonuses_12x8 );
		SetSquareBonuses( 1, rookSquareBonuses_12x8 );
		SetSquareBonuses( 2, rookSquareBonuses_12x8 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		SetTropism( 7, -8 );
		SetTropism( 8, -8 );
		SetTropism( 9, -8 );
		SetTropism( 10, -8 );
		SetTropism( 11, -8 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Rook_12x8 rook_12x8;
};

class Bishop_12x8:
	public PieceType96
{
  public:
	//	construction
	Bishop_12x8():
		PieceType96("Bishop", "Bishop", "B", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\W.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\B.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3750;
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 3500;
			perCaptureValueBonus = 35;
			perCaptureBonusThreshold = 15;
			SetSquareBonuses( 0, bishopSquareBonuses_12x8 );
			SetSquareBonuses( 1, bishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, bishopSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Bishop_12x8 bishop_12x8;
};

class Knight_12x8:
	public PieceType96
{
  public:
	//	construction
	Knight_12x8():
		PieceType96("Knight", "Knight", "N", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		optimization = SimpleSingleStep;
		if( personality >= PERSONALITY_C )
		{
			baseValue = 2750;
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 2750;
			SetSquareBonuses( 0, knightSquareBonuses_12x8 );
			SetSquareBonuses( 1, knightSquareBonuses_12x8 );
			SetSquareBonuses( 2, knightSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Knight_12x8 knight_12x8;
};

class Queen_12x8:
	public PieceType96
{
  public:
	//	construction
	Queen_12x8():
		PieceType96("Queen", "Queen", "Q", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		optimization = SimpleSlider;
		if( personality >= PERSONALITY_C )
		{
			baseValue = 10000;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 9750;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 15;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, queenSquareBonuses_12x8 );
			SetSquareBonuses( 2, queenSquareBonuses_12x8 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Queen_12x8 queen_12x8;
};

class King_12x8:
	public PieceType96
{
  public:
	//	construction
	King_12x8():
		PieceType96("King", "King", "K", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		SetSquareBonuses( 0, kingSquareBonuses_12x8 );
		SetSquareBonuses( 1, kingSquareBonuses_12x8 );
		SetSquareBonuses( 2, endgameKingSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		isRoyal = true;
		baseValue = 0;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static King_12x8 king_12x8;
};

class Pawn_12x8:
	public PieceType96
{
  public:
	//	construction
	Pawn_12x8():
		PieceType96("Pawn", "Pawn", "P", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 2, MoveOnly, 0, 23 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly, 24, 95 ) );
		}

		SetSquareBonuses( 0, openingPawnSquareBonuses_12x8 );
		SetSquareBonuses( 1, pawnSquareBonuses_12x8 );
		SetSquareBonuses( 2, pawnSquareBonuses_12x8 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		baseValue = 1000;
		isPawn = true;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Pawn_12x8 pawn_12x8;
};

class LamePawn_12x8:
	public PieceType96
{
  public:
	//	construction
	LamePawn_12x8():
		PieceType96("Pawn", "Pawn", "P", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly ) );
		}

		SetSquareBonuses( 0, openingPawnSquareBonuses_12x8 );
		SetSquareBonuses( 1, pawnSquareBonuses_12x8 );
		SetSquareBonuses( 2, pawnSquareBonuses_12x8 );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		baseValue = 1000;
		isPawn = true;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static LamePawn_12x8 lamePawn_12x8;
};

class Archbishop_12x8:
	public PieceType96
{
  public:
	//	construction
	Archbishop_12x8():
		PieceType96("Archbishop", "Archbishop", "A", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCardinal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCardinal2.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WArchbishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BArchbishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightBishop.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 8000;
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 7500;
			perCaptureValueBonus = 35;
			perCaptureBonusThreshold = 15;
			SetSquareBonuses( 0, archbishopSquareBonuses_12x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Archbishop_12x8 archbishop_12x8;
};

class Chancellor_12x8:
	public PieceType96
{
  public:
	//	construction
	Chancellor_12x8():
		PieceType96("Chancellor", "Chancellor", "C", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WMarshal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BMarshal2.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightRook.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9750;
		}
		else
		{
			baseValue = 8750;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 15;
		}

		SetSquareBonuses( 0, chancellorSquareBonuses_12x8 );
		SetSquareBonuses( 1, chancellorSquareBonuses_12x8 );
		SetSquareBonuses( 2, chancellorSquareBonuses_12x8 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Chancellor_12x8 chancellor_12x8;
};

class Amazon_12x8:
	public PieceType96
{
  public:
	//	construction
	Amazon_12x8():
		PieceType96("Amazon", "Amazon", "A", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WAmazon.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BAmazon.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WChancellor.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WAmazon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BAmazon.bmp";
	//		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightRook.bmp";
	//		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightRook.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 12500;
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 11750;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 15;
			SetSquareBonuses( 0, queenSquareBonuses_12x8 );
			SetSquareBonuses( 1, queenSquareBonuses_12x8 );
			SetSquareBonuses( 2, queenSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Amazon_12x8 amazon_12x8;
};

class Lion_12x8:
	public PieceType96
{
  public:
	//	construction
	Lion_12x8():
		PieceType96("Half-Duck", "Lion", "L", 8, 10)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLion.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WHalfDuck.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BHalfDuck.bmp";
			AddMovementCapability( MovementCapability(  0,  3, 1 ) );
			AddMovementCapability( MovementCapability(  3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 5500;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			SetSquareBonuses( 0, knightSquareBonuses_12x8 );
			SetSquareBonuses( 1, knightSquareBonuses_12x8 );
			SetSquareBonuses( 2, knightSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Lion_12x8 lion_12x8;
};

class General_12x8:
	public PieceType96
{
  public:
	//	construction
	General_12x8():
		PieceType96("General", "General", "G", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WDuke.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDuke.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
		}
		else
		{
		}

		SetSquareBonuses( 0, queenSquareBonuses_12x8 );
		SetSquareBonuses( 1, queenSquareBonuses_12x8 );
		SetSquareBonuses( 2, queenSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 3250;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static General_12x8 general_12x8;
};

class KnightGeneral_12x8:
	public PieceType96
{
  public:
	//	construction
	KnightGeneral_12x8():
		PieceType96("Knight-General", "Knight-General", "_NG", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGuardKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawnKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawnKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WGeneral.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BGeneral.bmp";
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 5750;
		optimization = SimpleSingleStep;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			SetSquareBonuses( 0, knightSquareBonuses_12x8 );
			SetSquareBonuses( 1, knightSquareBonuses_12x8 );
			SetSquareBonuses( 2, knightSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static KnightGeneral_12x8 knightGeneral_12x8;
};

class Elephant_12x8:
	public PieceType96
{
  public:
	//	construction
	Elephant_12x8():
		PieceType96("Elephant", "Elephant", "E", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		}

		baseValue = 1000;
		optimization = SimpleSingleStep;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			SetSquareBonuses( 0, bishopSquareBonuses_12x8 );
			SetSquareBonuses( 1, bishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, bishopSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Elephant_12x8 elephant_12x8;
};

class Ferz_12x8:
	public PieceType96
{
  public:
	//	construction
	Ferz_12x8():
		PieceType96("Ferz", "General", "G", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFers.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFers.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCounsellor.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCounsellor.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
		SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
		SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 1500;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Ferz_12x8 ferz_12x8;
};

class Wazir_12x8:
	public PieceType96
{
  public:
	//	construction
	Wazir_12x8():
		PieceType96("Wazir", "Schleich", "S", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWazir.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BWazir.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		}

		SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
		SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
		SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 1450;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Wazir_12x8 wazir_12x8;
};

class Camel_12x8:
	public PieceType96
{
  public:
	//	construction
	Camel_12x8():
		PieceType96("Camel", "Camel", "C", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamel.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamel.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WCamel.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BCamel.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCamel.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCamel.bmp";
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		baseValue = 2000;
		optimization = SimpleSingleStep;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			SetSquareBonuses( 0, knightSquareBonuses_12x8 );
			SetSquareBonuses( 1, knightSquareBonuses_12x8 );
			SetSquareBonuses( 2, knightSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Camel_12x8 camel_12x8;
};

class Squirrel_12x8:
	public PieceType96
{
  public:
	//	construction
	Squirrel_12x8():
		PieceType96("Squirrel", "Squirrel", "S", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			//	call base class's Initialize function
			PieceType96::Initialize( personality );

			//	initialize all properties to defaults
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WButterfly.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BButterfly.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WLion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BLion.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
		SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
		SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		baseValue = 6000;
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Squirrel_12x8 squirrel_12x8;
};

class Sage_12x8:
	public PieceType96
{
  public:
	//	construction
	Sage_12x8():
		PieceType96("Sage", "Sage", "S", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamelBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamelBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6650;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 6150;
			perCaptureValueBonus = 25;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_12x8 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Sage_12x8 sage_12x8;
};

class Tower_12x8:
	public PieceType96
{
  public:
	//	construction
	Tower_12x8():
		PieceType96("Tower", "Tower", "T", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamelRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamelRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9500;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 8500;
			perCaptureValueBonus = 65;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, chancellorSquareBonuses_12x8 );
			SetSquareBonuses( 2, chancellorSquareBonuses_12x8 );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static Tower_12x8 tower_12x8;
};

class DragonKing_12x8:
	public PieceType96
{
  public:
	//	construction
	DragonKing_12x8():
		PieceType96("Dragon King", "Dragon King", "_DK", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPromotedRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPromotedRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 7250;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 6750;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, chancellorSquareBonuses_12x8 );
			SetSquareBonuses( 2, chancellorSquareBonuses_12x8 );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 6 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static DragonKing_12x8 dragonKing_12x8;
};

class DragonHorse_12x8:
	public PieceType96
{
  public:
	//	construction
	DragonHorse_12x8():
		PieceType96("Dragon Horse", "Dragon Horse", "_DH", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPromotedBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPromotedBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6650;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 5900;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 8;
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_12x8 );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 6 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static DragonHorse_12x8 dragonHorse_12x8;
};

class Unicorn_12x8:
	public PieceType96
{
  public:
	//	construction
	Unicorn_12x8():
		PieceType96("Unicorn", "Unicorn", "U", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WUnicorn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BUnicorn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WNightPrincess.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BNightPrincess.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 0 ) );
			AddMovementCapability( MovementCapability(  1,  2, 0 ) );
			AddMovementCapability( MovementCapability( -2,  1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 0 ) );
			AddMovementCapability( MovementCapability(  1, -2, 0 ) );
			AddMovementCapability( MovementCapability( -2, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2, -1, 0 ) );
		}

		baseValue = 9500;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			SetSquareBonuses( 0, openingQueenSquareBonuses_12x8 );
			SetSquareBonuses( 1, archbishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, archbishopSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Unicorn_12x8 unicorn_12x8;
};

class Cleric_12x8:
	public PieceType96
{
  public:
	//	construction
	Cleric_12x8():
		PieceType96("Cleric", "Cleric", "C", 8, 12)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishopWarMachine.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishopWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBede.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBede.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 5550;
			SetSquareBonuses( 0, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 1, genericLargeCenterBonuses_12x8 );
			SetSquareBonuses( 2, genericLargeCenterBonuses_12x8 );
		}
		else
		{
			baseValue = 5500;
			perCaptureValueBonus = 35;
			perCaptureBonusThreshold = 15;
			SetSquareBonuses( 0, bishopSquareBonuses_12x8 );
			SetSquareBonuses( 1, bishopSquareBonuses_12x8 );
			SetSquareBonuses( 2, bishopSquareBonuses_12x8 );
		}
	}

	static BitBoard96 bitboard[2];
	static BitBoard96 moveArray;
	static Cleric_12x8 cleric_12x8;
};


#endif
