
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__GAME_12x8_H
#define FILE__GAME_12x8_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"
#include "12x8_Types.h"


//	***********************
//	**                   **
//	**     Game_12x8     **
//	**                   **
//	***********************

class Game_12x8:
	public Game
{
  protected:
	//	data members
	PieceType96 *rookPieceTypes[2];
	PieceType96 *minorPieceTypes[2][6];
	PieceType96 *colorboundPieceTypes[2][3];
	PieceType96 *majorPieceTypes[2][4];
	PieceType96 *pawnPieceTypes[2];
	
	HashMap *enPassantHashMap;
	//	Zobrist keys which are x-or'ed into the board's primary hash
	//	for the current "en passant" square, if any

	word32 castlingHash0k;	//	\   Zobrist keys for castling privledge.
	word32 castlingHash0q;	//	 \_ these values are x-or'ed in if the
	word32 castlingHash1k;	//	 /  player has not lost the ability to
	word32 castlingHash1q;	//	/   castle on the given side.

	//	variant information
	bool enPassant;			//	does this game have the en-passant rule?
	int castlingType;		//	castling type (none, standard, long, flexible, close-rook)
	int pawnPromotionType;	//	promotion type (standard, major)


	//	useful bitboards
	BitBoard96 secondRank;
	BitBoard96 seventhRank;


  public:
	// *** INITIALIZATION *** //
	Game_12x8( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );

	virtual void ChangeRulesByVariableDefinition( char *gameName );


	// ******************************* //
	// ***                         *** //
	// ***     VIRTUAL METHODS     *** //
	// ***                         *** //
	// ******************************* //

	virtual void SetPersonality
		( int personality );

	virtual bool RemovePieceType
		( PieceType *pieceType );

	virtual bool AddPieceType
		( PieceType *pieceType,
		  int nPlayer );

	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual word32 AdjustPrimaryHash
		( word32 primaryHash );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual int EnumeratePromotions
		( Piece *piece,
		  int fromSquare,
		  int toSquare,
		  PieceType **promotions,
		  bool quiescentSearch );

	virtual void DefaultSettings();

	virtual void AboutToStartThinking
		( int currentPlayer );

	virtual void AboutToDeepenSearch
		( int currentPlayer );
};


#endif
