
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ALAPO_TYPES_H
#define FILE__ALAPO_TYPES_H


class AlapoLargeSquare:
	public PieceType64
{
  public:
	//	construction
	AlapoLargeSquare():
		PieceType64("Large Square", "Large Square", "LS", 6, 6)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSquare.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSquare.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		baseValue = 2200;
	}

	static AlapoLargeSquare alapoLargeSquare;
};

class AlapoSmallSquare:
	public PieceType64
{
  public:
	//	construction
	AlapoSmallSquare():
		PieceType64("Small Square", "Small Square", "SS", 6, 6)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSmallSquare.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSmallSquare.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWazir.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		}

		baseValue = 900;
	}

	static AlapoSmallSquare alapoSmallSquare;
};

class AlapoLargeTriangle:
	public PieceType64
{
  public:
	//	construction
	AlapoLargeTriangle():
		PieceType64("Large Triangle", "Large Triangle", "LT", 6, 6)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WTriangle.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDownTriangle.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		baseValue = 1800;
	}

	static AlapoLargeTriangle alapoLargeTriangle;
};

class AlapoSmallTriangle:
	public PieceType64
{
  public:
	//	construction
	AlapoSmallTriangle():
		PieceType64("Small Triangle", "Small Triangle", "ST", 6, 6)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSmallTriangle.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDownSmallTriangle.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFers.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFers.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 1250;
	}

	static AlapoSmallTriangle alapoSmallTriangle;
};

class AlapoLargeCircle:
	public PieceType64
{
  public:
	//	construction
	AlapoLargeCircle():
		PieceType64("Large Circle", "Large Circle", "LC", 6, 6)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCircle.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCircle.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		baseValue = 4000;
	}

	static AlapoLargeCircle alapoLargeCircle;
};

class AlapoSmallCircle:
	public PieceType64
{
  public:
	//	construction
	AlapoSmallCircle():
		PieceType64("Small Circle", "Small Circle", "SC", 6, 6)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSmallCircle.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSmallCircle.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 1900;
	}

	static AlapoSmallCircle alapoSmallCircle;
};


#endif
