
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2006 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__CHESS_WITH_AUGMENTED_KNIGHTS_GAME_H
#define FILE__CHESS_WITH_AUGMENTED_KNIGHTS_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "ChessPieceTypes.h"
#include "ChessGame.h"


//	**********************
//	**                  **
//	**     CWAKGame     **
//	**                  **
//	**********************


class CWAKGame:
	public ChessGame
{
  protected:
	//	piece types for Chess with Augmented Knights
//	OrthodoxKnight augmentedKnight0Type;
//	OrthodoxKnight augmentedKnight1Type;


  public:
	// *** INITIALIZATION *** //
	CWAKGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void Initialize();

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );
};


#endif
