
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../Resource.h"
#include "../../GameParameters.h"
#include "ChessGame.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


LRESULT CALLBACK CWAK_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	char buffer[20];
	int whiteArmy;
	int blackArmy;

	switch( Msg )
	{
	  case WM_INITDIALOG:
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Standard Knight" );
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Ferz" );
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Wazir" );
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Dabbabah" );
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Alfil" );
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Random" );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Standard Knight" );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Ferz" );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Wazir" );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Dabbabah" );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Knight+Alfil" );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_ADDSTRING, 0, (LPARAM) "Random" );
		::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_SETCURSEL, (WPARAM) 5, (LPARAM) 0 );
		::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_SETCURSEL, (WPARAM) 5, (LPARAM) 0 );
		::SendDlgItemMessage( hWndDlg, IDC_THINK_TIME_EDIT, WM_SETTEXT, (WPARAM) 0, (LPARAM) "20" );
		::SendDlgItemMessage( hWndDlg, IDC_OPENING_BOOK_CHECK, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		return TRUE;

	  case WM_COMMAND:
		switch(wParam)
		{
		  case IDOK:
			whiteArmy = (int) ::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_GETCURSEL, 0, (LPARAM) 0 );
			blackArmy = (int) ::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_GETCURSEL, 0, (LPARAM) 0 );

			//	check for random
			if( whiteArmy == 5 )
				whiteArmy = (rand() % 4) + 1;
			if( blackArmy == 5 )
				blackArmy = (rand() % 4) + 1;

			whiteComp = ::SendDlgItemMessage( hWndDlg, IDC_WHITE_COMPCONTROL, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			blackComp = ::SendDlgItemMessage( hWndDlg, IDC_BLACK_COMPCONTROL, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			useOpeningBook = ::SendDlgItemMessage( hWndDlg, IDC_OPENING_BOOK_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			::SendDlgItemMessage( hWndDlg, IDC_THINK_TIME_EDIT, WM_GETTEXT, (WPARAM) 18, (LPARAM) buffer );
			maxThinkTime = atoi( buffer );

			char buffer[50];
			::SendDlgItemMessage( hWndDlg, IDC_WHITE_KNIGHT, CB_GETLBTEXT, whiteArmy, (LPARAM) buffer );
			StoreParameter( "white-knight", buffer );
			::SendDlgItemMessage( hWndDlg, IDC_BLACK_KNIGHT, CB_GETLBTEXT, blackArmy, (LPARAM) buffer );
			StoreParameter( "black-knight", buffer );

			if( whiteArmy == 0 && blackArmy == 0 )
				::EndDialog( hWndDlg, CHESS_GAME_ORTHODOX );
			else
				::EndDialog( hWndDlg, CHESS_GAME_CWAK );
			return TRUE;
		}
		break;
	}
	return FALSE;
}
