
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2007 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__CHESS_PIECE_TYPES_H
#define FILE__CHESS_PIECE_TYPES_H


#include "../../Personality.h"


class OrthodoxRook:
	public PieceType64
{
  public:
	//	construction
	OrthodoxRook():
		PieceType64("Rook", "Rook", "R", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WRook.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		baseValue = 4750;
		SetSquareBonuses( 0, rookSquareBonuses );
		SetSquareBonuses( 1, rookSquareBonuses );
		SetSquareBonuses( 2, rookSquareBonuses );
		SetMobility( AutomaticBitboardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		armyAdjustment = 0;
		optimization = SimpleSlider;
	}

	static OrthodoxRook orthodoxRook;
};

class OrthodoxBishop:
	public PieceType64
{
  public:
	//	construction
	OrthodoxBishop():
		PieceType64("Bishop", "Bishop", "B", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		baseValue = 3000;
		SetSquareBonuses( 0, bishopSquareBonuses );
		SetSquareBonuses( 1, bishopSquareBonuses );
		SetSquareBonuses( 2, bishopSquareBonuses );
		SetMobility( AutomaticBitboardMobility, -8, 24 );
		SetTropismType( DistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -1 );
		SetTropism( 3, -3 );
		SetTropism( 4, -5 );
		SetTropism( 5, -7 );
		SetTropism( 6, -7 );
		SetTropism( 7, -7 );
		armyAdjustment = 0;
		optimization = SimpleSlider;
	}

	static OrthodoxBishop orthodoxBishop;
};

class OrthodoxKnight:
	public PieceType64
{
  public:
	//	construction
	OrthodoxKnight():
		PieceType64("Knight", "Knight", "N", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 3000;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static OrthodoxKnight orthodoxKnight;
};

class OrthodoxQueen:
	public PieceType64
{
  public:
	//	construction
	OrthodoxQueen():
		PieceType64("Queen", "Queen", "Q", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}

		baseValue = 8500;
		SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
		SetSquareBonuses( 1, queenSquareBonuses );
		SetSquareBonuses( 2, queenSquareBonuses );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		armyAdjustment = 0;
		optimization = SimpleSlider;
	}

	static OrthodoxQueen orthodoxQueen;
};

class OrthodoxKing:
	public PieceType64
{
  public:
	//	construction
	OrthodoxKing():
		PieceType64("King", "King", "K", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 25000;
		SetSquareBonuses( 0, kingSquareBonuses );
		SetSquareBonuses( 1, kingSquareBonuses );
		SetSquareBonuses( 2, endgameKingSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
		isRoyal = true;
	}

	static OrthodoxKing orthodoxKing;
};

class SpartanKing:
	public PieceType64
{
  public:
	//	construction
	SpartanKing():
		PieceType64("Spartan King", "King", "K", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKing.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 25000;
		SetSquareBonuses( 0, endgameKingSquareBonuses );
		SetSquareBonuses( 1, endgameKingSquareBonuses );
		SetSquareBonuses( 2, endgameKingSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
		isRoyal = true;
	}

	static SpartanKing spartanKing;
};

class OrthodoxPawn:
	public PieceType64
{
  public:
	//	construction
	OrthodoxPawn():
		PieceType64("Pawn", "Pawn", "P", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 2, MoveOnly, 0, 15 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly, 16, 63 ) );
		}

		baseValue = 1000;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, openingPawnSquareBonuses_CD );
			SetSquareBonuses( 1, pawnSquareBonuses );
			SetSquareBonuses( 2, endgamePawnSquareBonuses );
		}
		else
		{
			SetSquareBonuses( 0, openingPawnSquareBonuses );
			SetSquareBonuses( 1, pawnSquareBonuses );
			SetSquareBonuses( 2, endgamePawnSquareBonuses );
		}
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		armyAdjustment = 0;
		isPawn = true;
	}

	virtual void BB64_Initialize()
	{
		//	call base class's BB64_Initialize function
		PieceType64::BB64_Initialize();

		//	now add the single-step non-capturing move from the 
		//	starting rank; the two-step move will be handled specially by 
		//	ChessGame::GenerateMoves()
		for( int x = 0; x < 8; x++ )
		{
			bb64_direct_move_no_capture[0][x+8].SetBit( x + 16 );
			bb64_direct_move_no_capture[1][x+48].SetBit( x + 40 );
		}
	}

	static OrthodoxPawn orthodoxPawn;
};

class BerolinaPawn:
	public PieceType64
{
  public:
	//	construction
	BerolinaPawn():
		PieceType64("Berolina Pawn", "Pawn", "P", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 2, MoveOnly, 0, 15 ) );
			AddMovementCapability( MovementCapability( -1, 1, 2, MoveOnly, 0, 15 ) );
			AddMovementCapability( MovementCapability(  1, 1, 1, MoveOnly, 16, 63 ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, MoveOnly, 16, 63 ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, CaptureOnly ) );
		}

		SetSquareBonuses( 0, openingPawnSquareBonuses );
		SetSquareBonuses( 1, pawnSquareBonuses );
		SetSquareBonuses( 2, endgamePawnSquareBonuses );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		baseValue = 1000;
		isPawn = true;
	}

	static BerolinaPawn berolinaPawn;
};

class LamePawn:
	public PieceType64
{
  public:
	//	construction
	LamePawn():
		PieceType64("Lame Pawn", "Pawn", "P", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly ) );
		}

		SetSquareBonuses( 0, openingPawnSquareBonuses );
		SetSquareBonuses( 1, pawnSquareBonuses );
		SetSquareBonuses( 2, endgamePawnSquareBonuses );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		baseValue = 1000;
		isPawn = true;
	}

	static LamePawn lamePawn;
};

class Hoplite:
	public PieceType64
{
  public:
	//	construction
	Hoplite():
		PieceType64("Hoplite", "Hoplite", "H", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1,  1, 1, MoveOnly ) );
			AddMovementCapability( MovementCapability(  0,  1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  2,  2, 1, MoveOnly, 0, 15 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1, MoveOnly, 0, 15 ) );
		}

		baseValue = 970;
		SetSquareBonuses( 0, pawnSquareBonuses );
		SetSquareBonuses( 1, pawnSquareBonuses );
		SetSquareBonuses( 2, endgamePawnSquareBonuses );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		isPawn = false;
	}

	virtual void BB64_Initialize()
	{
		//	call base class's BB64_Initialize function
		PieceType64::BB64_Initialize();
/*
		//	now add the single-step non-capturing move from the 
		//	starting rank; the two-step move will be handled specially by 
		//	ChessGame::GenerateMoves()
		for( int x = 0; x < 8; x++ )
		{
			bb64_direct_move_no_capture[0][x+8].SetBit( x + 16 );
			bb64_direct_move_no_capture[1][x+48].SetBit( x + 40 );
		}*/
	}

	static Hoplite hoplite;
};

class DiamondPawn:
	public PieceType64
{
  public:
	//	construction
	DiamondPawn():
		PieceType64("Diamond Pawn", "Pawn", "P", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
			AddMovementCapability( MovementCapability( -1, 0, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, 1, 1, CaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, 1, 1, MoveOnly ) );
			promotion.SetPromotionCapability( PromoteToVariableTypes );
		}

		baseValue = 1000;
		isPawn = true;
	}

	static DiamondPawn diamondPawn;
};

class Elephant:
	public PieceType64
{
  public:
	//	construction
	Elephant():
		PieceType64("Elephant", "Elephant", "E", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, waffleSquareBonuses );
		SetSquareBonuses( 1, waffleSquareBonuses );
		SetSquareBonuses( 2, waffleSquareBonuses );
		optimization = SimpleSingleStep;
	}

	static Elephant elephant;
};

class Ferz:
	public PieceType64
{
  public:
	//	construction
	Ferz():
		PieceType64("Ferz", "General", "G", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFers.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFers.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCounsellor.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCounsellor.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 1850;
		armyAdjustment = 0;
		SetSquareBonuses( 0, ferzSquareBonuses );
		SetSquareBonuses( 1, ferzSquareBonuses );
		SetSquareBonuses( 2, ferzSquareBonuses );
		optimization = SimpleSingleStep;
	}

	static Ferz ferz;
};

class ElephantFerz:
	public PieceType64
{
  public:
	//	construction
	ElephantFerz():
		PieceType64("Elephant-Ferz", "Elephant", "E", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 2750;
		armyAdjustment = 0;
		SetSquareBonuses( 0, waffleSquareBonuses );
		SetSquareBonuses( 1, waffleSquareBonuses );
		SetSquareBonuses( 2, waffleSquareBonuses );
		optimization = SimpleSingleStep;
	}

	static ElephantFerz elephantFerz;
};

class Lieutenant:
	public PieceType64
{
  public:
	//	construction
	Lieutenant():
		PieceType64("Lieutenant", "Lieutenant", "L", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1,  0, 1, MoveOnly ) );
		}

		baseValue = 3000;
		SetSquareBonuses( 0, waffleSquareBonuses );
		SetSquareBonuses( 1, waffleSquareBonuses );
		SetSquareBonuses( 2, waffleSquareBonuses );
	}

	static Lieutenant lieutenant;
};

class General:
	public PieceType64
{
  public:
	//	construction
	General():
		PieceType64("General", "General", "G", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		if( !initialized )
		{
			//	initialize all properties to defaults
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WGuard.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WGeneral.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BGeneral.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WGuard.bmp";
	//		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BGuard.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
			bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		}

		baseValue = 3300;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			SetSquareBonuses( 0, knightSquareBonuses );
			SetSquareBonuses( 1, knightSquareBonuses );
			SetSquareBonuses( 2, knightSquareBonuses );
		}
		optimization = SimpleSingleStep;
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static General general;
};

class SilverGeneral:
	public PieceType64
{
  public:
	//	construction
	SilverGeneral():
		PieceType64("Silver General", "Silver General", "S", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSilverGeneral.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSilverGeneral.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		}

		optimization = SimpleSingleStep;
		baseValue = 2850;
	}

	static SilverGeneral silverGeneral;
};

class Phoenix:
	public PieceType64
{
  public:
	//	construction
	Phoenix():
		PieceType64("Phoenix", "Phoenix", "_PH", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephantWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephantWazir.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWaffle.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWaffle.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 2875;
			SetSquareBonuses( 0, waffleSquareBonuses );
			SetSquareBonuses( 1, waffleSquareBonuses );
			SetSquareBonuses( 2, waffleSquareBonuses );
		}
		optimization = SimpleSingleStep;
		armyAdjustment = 0;
	}

	static Phoenix phoenix;
};

class Cleric:
	public PieceType64
{
  public:
	//	construction
	Cleric():
		PieceType64("Cleric", "Cleric", "_CL", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishopWarMachine.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishopWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBede.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBede.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 4600;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 4725;
			SetSquareBonuses( 0, bedeSquareBonuses );
			SetSquareBonuses( 1, bedeSquareBonuses );
			SetSquareBonuses( 2, bedeSquareBonuses );
		}
		armyAdjustment = 0;
	}

	static Cleric cleric;
};

class WarElephant:
	public PieceType64
{
  public:
	//	construction
	WarElephant():
		PieceType64("War Elephant", "War Elephant", "_WE", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephantFerzWarMachine.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephantFerzWarMachine.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFAD.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFAD.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 4600;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 4725;
			SetSquareBonuses( 0, fadSquareBonuses );
			SetSquareBonuses( 1, fadSquareBonuses );
			SetSquareBonuses( 2, fadSquareBonuses );
		}
		optimization = SimpleSingleStep;
		armyAdjustment = 0;
	}

	static WarElephant warElephant;
};

class Archbishop:
	public PieceType64
{
  public:
	//	construction
	Archbishop():
		PieceType64("Archbishop", "Archbishop", "A", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCardinal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCardinal2.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCardinal.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCardinal.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WArchbishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BArchbishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 7750;
		SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
		SetSquareBonuses( 1, archbishopSquareBonuses );
		SetSquareBonuses( 2, archbishopSquareBonuses );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		armyAdjustment = 0;
	}

	static Archbishop archbishop;
};

class ChargingRook:
	public PieceType64
{
  public:
	//	construction
	ChargingRook():
		PieceType64("Charging Rook", "Charging Rook", "_CR", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WForwardRookBackwardsPrince.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BForwardRookBackwardsPrince.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WChargingRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BChargingRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 5000;
		}
		else
		{
			baseValue = 4500;
			perCaptureValueBonus = 30;
			perCaptureBonusThreshold = 10;
		}
		SetSquareBonuses( 0, rookSquareBonuses );
		SetSquareBonuses( 1, rookSquareBonuses );
		SetSquareBonuses( 2, rookSquareBonuses );
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		armyAdjustment = 0;
	}

	static ChargingRook chargingRook;
};

class NarrowKnight:
	public PieceType64
{
  public:
	//	construction
	NarrowKnight():
		PieceType64("Narrow Knight", "Narrow Knight", "_NN", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WNarrowKnightFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BNarrowKnightFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFibnif.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFibnif.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 2950;
			SetSquareBonuses( 0, knightSquareBonuses );
			SetSquareBonuses( 1, knightSquareBonuses );
			SetSquareBonuses( 2, knightSquareBonuses );
		}
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static NarrowKnight narrowKnight;
};

class ChargingKnight:
	public PieceType64
{
  public:
	//	construction
	ChargingKnight():
		PieceType64("Charging Knight", "Charging Knight", "_CN", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WForwardKnightBackwardsPrince.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BForwardKnightBackwardsPrince.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WChargingKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BChargingKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
			baseValue = 3000;
		else
			baseValue = 3100;
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static ChargingKnight chargingKnight;
};

class Colonel:
	public PieceType64
{
  public:
	//	construction
	Colonel():
		PieceType64("Colonel", "Colonel", "_CO", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WForwardChancellorPrince.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BForwardChancellorPrince.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9000;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 8600;
			perCaptureValueBonus = 20;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, chancellorSquareBonuses );
			SetSquareBonuses( 2, chancellorSquareBonuses );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
		armyAdjustment = 0;
	}

	static Colonel colonel;
};

class ShortRook:
	public PieceType64
{
  public:
	//	construction
	ShortRook():
		PieceType64("Short Rook", "Short Rook", "_SR", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		//	initialize all properties to defaults
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WHalfRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BHalfRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WShortRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BShortRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 4 ) );
			AddMovementCapability( MovementCapability( -1,  0, 4 ) );
			AddMovementCapability( MovementCapability(  0,  1, 4 ) );
			AddMovementCapability( MovementCapability(  0, -1, 4 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3750;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 3750;
			perCaptureValueBonus = 10;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, shortRookSquareBonuses );
			SetSquareBonuses( 1, shortRookSquareBonuses );
			SetSquareBonuses( 2, shortRookSquareBonuses );
		}
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		armyAdjustment = 0;
	}

	static ShortRook shortRook;
};

class Bowman:
	public PieceType64
{
  public:
	//	construction
	Bowman():
		PieceType64("Bowman", "Bowman", "_BO", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WArcher.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BArcher.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWoodyRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWoodyRook.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
		}

		baseValue = 2850;
		SetSquareBonuses( 0, woodyRookSquareBonuses );
		SetSquareBonuses( 1, woodyRookSquareBonuses );
		SetSquareBonuses( 2, woodyRookSquareBonuses );
		if( personality >= PERSONALITY_C )
			baseValue = 3000;
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static Bowman bowman;
};

class Lion:
	public PieceType64
{
  public:
	//	construction
	Lion():
		PieceType64("Lion", "Lion", "L", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLion.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLion.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WHalfDuck.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BHalfDuck.bmp";
			AddMovementCapability( MovementCapability(  0,  3, 1 ) );
			AddMovementCapability( MovementCapability(  3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 4500;
		if( personality >= PERSONALITY_C )
		{
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			SetSquareBonuses( 0, halfDuckSquareBonuses );
			SetSquareBonuses( 1, halfDuckSquareBonuses );
			SetSquareBonuses( 2, halfDuckSquareBonuses );
		}
		optimization = SimpleSingleStep;
		armyAdjustment = 0;
	}

	static Lion lion;
};

class Chancellor:
	public PieceType64
{
  public:
	//	construction
	Chancellor():
		PieceType64("Chancellor", "Chancellor", "C", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WMarshal2.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BMarshal2.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WChancellor.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BChancellor.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnightRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnightRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 9000;
		SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
		SetSquareBonuses( 1, chancellorSquareBonuses );
		SetSquareBonuses( 2, chancellorSquareBonuses );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
		armyAdjustment = 0;
	}

	static Chancellor chancellor;
};

class Forequeen:
	public PieceType64
{
  public:
	//	construction
	Forequeen():
		PieceType64("Forequeen", "Forequeen", "_FQ", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFQueenBKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFQueenBKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WForequeen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BForequeen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9000;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 8750;
			perCaptureValueBonus = 55;
			perCaptureBonusThreshold = 11;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, chancellorSquareBonuses );
			SetSquareBonuses( 2, chancellorSquareBonuses );
		}
		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		armyAdjustment = 0;
	}

	static Forequeen forequeen;
};

class Bishight:
	public PieceType64
{
  public:
	//	construction
	Bishight():
		PieceType64("Bishight", "Bishight", "_BN", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFBishopBKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFBishopBKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishight.bmp";
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 3000;
		armyAdjustment = 0;
	}

	static Bishight bishight;
};

class Knishop:
	public PieceType64
{
  public:
	//	construction
	Knishop():
		PieceType64("Knishop", "Knishop", "_NB", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFKnightBBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFKnightBBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnishop.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		}

		baseValue = 3000;
		armyAdjustment = 0;
	}

	static Knishop knishop;
};

class Fourfer:
	public PieceType64
{
  public:
	//	construction
	Fourfer():
		PieceType64("Fourfer", "Fourfer", "_FR", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFortress.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFortress.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFourfer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFourfer.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 4 ) );
			AddMovementCapability( MovementCapability(  0, -1, 4 ) );
			AddMovementCapability( MovementCapability(  1,  0, 4 ) );
			AddMovementCapability( MovementCapability( -1,  0, 4 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 5600;
			perCaptureValueBonus = 40;
			perCaptureBonusThreshold = 11;
			SetSquareBonuses( 0, shortRookSquareBonuses );
			SetSquareBonuses( 1, shortRookSquareBonuses );
			SetSquareBonuses( 2, shortRookSquareBonuses );
		}
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		armyAdjustment = 0;
	}

	static Fourfer fourfer;
};

class Tiger:
	public PieceType64
{
  public:
	//	construction
	Tiger():
		PieceType64("Tiger", "Tiger", "D", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WTiger.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BTiger.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 3 ) );
			AddMovementCapability( MovementCapability(  0, -1, 3 ) );
			AddMovementCapability( MovementCapability(  1,  0, 3 ) );
			AddMovementCapability( MovementCapability( -1,  0, 3 ) );
			AddMovementCapability( MovementCapability( -1, -1, 3 ) );
			AddMovementCapability( MovementCapability(  1, -1, 3 ) );
			AddMovementCapability( MovementCapability( -1,  1, 3 ) );
			AddMovementCapability( MovementCapability(  1,  1, 3 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 5000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 4750;
			perCaptureValueBonus = 10;
			perCaptureBonusThreshold = 12;
			SetSquareBonuses( 0, shortRookSquareBonuses );
			SetSquareBonuses( 1, shortRookSquareBonuses );
			SetSquareBonuses( 2, shortRookSquareBonuses );
		}
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		armyAdjustment = 0;
	}

	static Tiger tiger;
};

class B4nD:
	public PieceType64
{
  public:
	//	construction
	B4nD():
		PieceType64("B4nD", "B4nD", "_B4", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WHalflingBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BHalflingBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WB4nD.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BB4nD.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability(  0, -1, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability(  1,  0, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability( -1,  0, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability( -1, -1, 4 ) );
			AddMovementCapability( MovementCapability(  1, -1, 4 ) );
			AddMovementCapability( MovementCapability( -1,  1, 4 ) );
			AddMovementCapability( MovementCapability(  1,  1, 4 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3750;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 3500;
			perCaptureValueBonus = 15;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, bedeSquareBonuses );
			SetSquareBonuses( 1, bedeSquareBonuses );
			SetSquareBonuses( 2, bedeSquareBonuses );
		}
		armyAdjustment = 0;
	}

	static B4nD b4nD;
};

class Templar:
	public PieceType64
{
  public:
	//	construction
	Templar():
		PieceType64("Templar", "Templar", "_TE", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WTemplar.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BTemplar.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability(  0, -1, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability(  1,  0, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability( -1,  0, 2, Normal, 0, 63, 0, 0, 2 ) );
			AddMovementCapability( MovementCapability( -1, -1, 2 ) );
			AddMovementCapability( MovementCapability(  1, -1, 2 ) );
			AddMovementCapability( MovementCapability( -1,  1, 2 ) );
			AddMovementCapability( MovementCapability(  1,  1, 2 ) );
	//		AddMovementCapability( MovementCapability(  0,  2, 1 ) );
	//		AddMovementCapability( MovementCapability(  0, -2, 1 ) );
	//		AddMovementCapability( MovementCapability(  2,  0, 1 ) );
	//		AddMovementCapability( MovementCapability( -2,  0, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 3000;
			perCaptureValueBonus = 8;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, bedeSquareBonuses );
			SetSquareBonuses( 1, bedeSquareBonuses );
			SetSquareBonuses( 2, bedeSquareBonuses );
		}
		armyAdjustment = 0;
	}

	static Templar templar;
};

class N2R4:
	public PieceType64
{
  public:
	//	construction
	N2R4():
		PieceType64("N2R4", "N2R4", "_N2", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WDuke.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDuke.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WN2R4.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BN2R4.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 4 ) );
			AddMovementCapability( MovementCapability(  0, -1, 4 ) );
			AddMovementCapability( MovementCapability(  1,  0, 4 ) );
			AddMovementCapability( MovementCapability( -1,  0, 4 ) );
			AddMovementCapability( MovementCapability( -1,  2, 2 ) );
			AddMovementCapability( MovementCapability(  1,  2, 2 ) );
			AddMovementCapability( MovementCapability( -2,  1, 2 ) );
			AddMovementCapability( MovementCapability(  2,  1, 2 ) );
			AddMovementCapability( MovementCapability( -1, -2, 2 ) );
			AddMovementCapability( MovementCapability(  1, -2, 2 ) );
			AddMovementCapability( MovementCapability( -2, -1, 2 ) );
			AddMovementCapability( MovementCapability(  2, -1, 2 ) );
		}

		baseValue = 9000;
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
		armyAdjustment = 0;
	}

	static N2R4 n2R4;
};

class Scout:
	public PieceType64
{
  public:
	//	construction
	Scout():
		PieceType64("Scout", "Scout", "_SC", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WScout.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BScout.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  3, 1 ) );
			AddMovementCapability( MovementCapability(  3,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  0, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 3000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 2900;
			SetSquareBonuses( 0, woodyRookSquareBonuses );
			SetSquareBonuses( 1, woodyRookSquareBonuses );
			SetSquareBonuses( 2, woodyRookSquareBonuses );
		}
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static Scout scout;
};

class Knightrider:
	public PieceType64
{
  public:
	//	construction
	Knightrider():
		PieceType64("Knightrider", "Knightrider", "_KR", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\Wnightrider.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\Bnightrider.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnightrider.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnightrider.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 0 ) );
			AddMovementCapability( MovementCapability(  1,  2, 0 ) );
			AddMovementCapability( MovementCapability( -2,  1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 0 ) );
			AddMovementCapability( MovementCapability(  1, -2, 0 ) );
			AddMovementCapability( MovementCapability( -2, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 5000;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 4700;
			perCaptureValueBonus = 10;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, archbishopSquareBonuses );
			SetSquareBonuses( 1, archbishopSquareBonuses );
			SetSquareBonuses( 2, archbishopSquareBonuses );
		}
		armyAdjustment = 0;
	}

	static Knightrider knightrider;
};

class DragonKing:
	public PieceType64
{
  public:
	//	construction
	DragonKing():
		PieceType64("Dragon King", "Dragon King", "_DK", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPromotedRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPromotedRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 7000;
		SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
		SetSquareBonuses( 1, chancellorSquareBonuses );
		SetSquareBonuses( 2, chancellorSquareBonuses );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 6 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static DragonKing dragonKing;
};

class DragonHorse:
	public PieceType64
{
  public:
	//	construction
	DragonHorse():
		PieceType64("Dragon Horse", "Dragon Horse", "_DH", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPromotedBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPromotedBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 5250;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 5000;
			perCaptureValueBonus = 15;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, archbishopSquareBonuses );
			SetSquareBonuses( 2, archbishopSquareBonuses );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 6 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static DragonHorse dragonHorse;
};

class Tower:
	public PieceType64
{
  public:
	//	construction
	Tower():
		PieceType64("Tower", "Tower", "T", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamelRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamelRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 7500;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 7250;
			perCaptureValueBonus = 50;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, chancellorSquareBonuses );
			SetSquareBonuses( 2, chancellorSquareBonuses );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static Tower tower;
};

class Sage:
	public PieceType64
{
  public:
	//	construction
	Sage():
		PieceType64("Sage", "Sage", "S", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCamelBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCamelBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  3, 1 ) );
			AddMovementCapability( MovementCapability(  1,  3, 1 ) );
			AddMovementCapability( MovementCapability( -3,  1, 1 ) );
			AddMovementCapability( MovementCapability(  3,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -3, 1 ) );
			AddMovementCapability( MovementCapability(  1, -3, 1 ) );
			AddMovementCapability( MovementCapability( -3, -1, 1 ) );
			AddMovementCapability( MovementCapability(  3, -1, 1 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6500;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 6000;
			perCaptureValueBonus = 15;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, archbishopSquareBonuses );
			SetSquareBonuses( 2, archbishopSquareBonuses );
		}

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
	}

	static BitBoard64 bitboard[2];
	static BitBoard64 moveArray;
	static Sage sage;
};

class Unicorn:
	public PieceType64
{
  public:
	//	construction
	Unicorn():
		PieceType64("Unicorn", "Unicorn", "U", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WUnicorn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BUnicorn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WNightPrincess.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BNightPrincess.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  2, 0 ) );
			AddMovementCapability( MovementCapability(  1,  2, 0 ) );
			AddMovementCapability( MovementCapability( -2,  1, 0 ) );
			AddMovementCapability( MovementCapability(  2,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 0 ) );
			AddMovementCapability( MovementCapability(  1, -2, 0 ) );
			AddMovementCapability( MovementCapability( -2, -1, 0 ) );
			AddMovementCapability( MovementCapability(  2, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 9000;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 8700;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
			SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
			SetSquareBonuses( 1, archbishopSquareBonuses );
			SetSquareBonuses( 2, archbishopSquareBonuses );
		}
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 4 );
		SetTropism( 3, 3 );
		SetTropism( 4, 2 );
		armyAdjustment = 0;
	}

	static Unicorn unicorn;
};
/*
class Cyborg:
	public PieceType64
{
  public:
	//	construction
	GSCyborg():
		PieceType64("Cyborg", "Cyborg", "_CY", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCyborg.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCyborg.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 2 ) );
			AddMovementCapability( MovementCapability( -1,  1, 2 ) );
			AddMovementCapability( MovementCapability(  1, -1, 2 ) );
			AddMovementCapability( MovementCapability( -1, -1, 2 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1, IguiCaptureOnly ) );
			AddMovementCapability( MovementCapability( -1,  0, 1, IguiCaptureOnly ) );
			AddMovementCapability( MovementCapability(  0,  1, 1, IguiCaptureOnly ) );
			AddMovementCapability( MovementCapability(  0, -1, 1, IguiCaptureOnly ) );
		}

		baseValue = 3050;
		armyAdjustment = 0;
	}

	static GSCyborg gscyborg;
};
*/
class SV7:
	public PieceType64
{
  public:
	//	construction
	SV7():
		PieceType64("SV7", "SV7", "SV", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSV7.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSV7.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 2 ) );
			AddMovementCapability( MovementCapability( -1,  0, 2 ) );
			AddMovementCapability( MovementCapability(  0,  1, 2 ) );
			AddMovementCapability( MovementCapability(  0, -1, 2 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1, IguiCaptureOnly ) );
			AddMovementCapability( MovementCapability( -1,  1, 1, IguiCaptureOnly ) );
			AddMovementCapability( MovementCapability(  1, -1, 1, IguiCaptureOnly ) );
			AddMovementCapability( MovementCapability( -1, -1, 1, IguiCaptureOnly ) );
		}

		baseValue = 3550;
		armyAdjustment = 0;
	}

	static SV7 sv7;
};

class GreaterKnight:
	public PieceType64
{
  public:
	//	construction
	GreaterKnight():
		PieceType64("Greater Knight", "Greater Knight", "_GN", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSuperKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSuperKnight.bmp";
			AddMovementCapability( MovementCapability( 0,  0, 2, AreaMover ) );
		}

		baseValue = 4000;
		armyAdjustment = 0;
	}

	static GreaterKnight greaterKnight;
};

class ShortQueen:
	public PieceType64
{
  public:
	//	construction
	ShortQueen():
		PieceType64("Short Queen", "Short Queen", "_SQ", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 3 ) );
			AddMovementCapability( MovementCapability( -1,  0, 3 ) );
			AddMovementCapability( MovementCapability(  0,  1, 3 ) );
			AddMovementCapability( MovementCapability(  0, -1, 3 ) );
			AddMovementCapability( MovementCapability(  1,  1, 3 ) );
			AddMovementCapability( MovementCapability( -1,  1, 3 ) );
			AddMovementCapability( MovementCapability(  1, -1, 3 ) );
			AddMovementCapability( MovementCapability( -1, -1, 3 ) );
		}

		baseValue = 6200;
		armyAdjustment = 0;
	}

	static ShortQueen shortQueen;
};

class BentHero:
	public PieceType64
{
  public:
	//	construction
	BentHero():
		PieceType64("Bent Hero", "Bent Hero", "H", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLemurianWarMachineWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLemurianWarMachineWazir.bmp";
		}

		SetSquareBonuses( 0, waffleSquareBonuses );
		SetSquareBonuses( 1, waffleSquareBonuses );
		SetSquareBonuses( 2, waffleSquareBonuses );
		baseValue = 8000;
	}

	static BentHero bentHero;
};

class BentShaman:
	public PieceType64
{
  public:
	//	construction
	BentShaman():
		PieceType64("Bent Shaman", "Bent Shaman", "S", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WLemurianElephantFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BLemurianElephantFerz.bmp";
		}

		SetSquareBonuses( 0, waffleSquareBonuses );
		SetSquareBonuses( 1, waffleSquareBonuses );
		SetSquareBonuses( 2, waffleSquareBonuses );
		baseValue = 7250;
	}

	static BentShaman bentShaman;
};

class SlidingGeneral:
	public PieceType64
{
  public:
	//	construction
	SlidingGeneral():
		PieceType64("Sliding General", "Sliding General", "G", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSlidingGeneral.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSlidingGeneral.bmp";
		}

		SetSquareBonuses( 0, waffleSquareBonuses );
		SetSquareBonuses( 1, waffleSquareBonuses );
		SetSquareBonuses( 2, waffleSquareBonuses );
		baseValue = 9500;
	}

	static SlidingGeneral slidingGeneral;
};

class Benz:
	public PieceType64
{
  public:
	//	construction
	Benz():
		PieceType64("Benz", "Benz", "_BZ", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFBishopBRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFBishopBRook.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 2300;
			SetSquareBonuses( 0, genericLargeCenterBonuses );
			SetSquareBonuses( 1, genericLargeCenterBonuses );
			SetSquareBonuses( 2, genericLargeCenterBonuses );
		}
		else
		{
			baseValue = 2300;
			SetSquareBonuses( 0, bishopSquareBonuses );
			SetSquareBonuses( 1, bishopSquareBonuses );
			SetSquareBonuses( 2, bishopSquareBonuses );
		}
		SetTropismType( DistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -1 );
		SetTropism( 3, -3 );
		SetTropism( 4, -5 );
		SetTropism( 5, -7 );
		SetTropism( 6, -7 );
		SetTropism( 7, -7 );
		armyAdjustment = 0;
		optimization = SimpleSlider;
	}

	static Benz benz;
};

class Pioneer:
	public PieceType64
{
  public:
	//	construction
	Pioneer():
		PieceType64("Pioneer", "Pioneer", "_PR", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPioneer.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPioneer.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 4250;
		SetSquareBonuses( 0, rookSquareBonuses );
		SetSquareBonuses( 1, rookSquareBonuses );
		SetSquareBonuses( 2, rookSquareBonuses );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		armyAdjustment = 0;
	}

	static Pioneer pioneer;
};

class Cyborg:
	public PieceType64
{
  public:
	//	construction
	Cyborg():
		PieceType64("Cyborg", "Cyborg", "_CY", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WSquirrelWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BSquirrelWazir.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  0, 1 ) );
			AddMovementCapability( MovementCapability( -2,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0,  2, 1 ) );
			AddMovementCapability( MovementCapability(  0, -2, 1 ) );
			AddMovementCapability( MovementCapability(  2,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 9400;
		perCaptureValueBonus = 75;
		perCaptureBonusThreshold = 10;
		SetSquareBonuses( 0, openingMajorPieceSquareBonuses );
		SetSquareBonuses( 1, queenSquareBonuses );
		SetSquareBonuses( 2, queenSquareBonuses );

		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static Cyborg cyborg;
};

class KnightWazir:
	public PieceType64
{
public:
	//	construction
	KnightWazir() :
		PieceType64( "Knight Wazir", "Knight Wazir", "N", 8, 8 )
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnightWazir.bmp";
			AddMovementCapability( MovementCapability( -1, 2, 1 ) );
			AddMovementCapability( MovementCapability( 1, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability( 1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 1,  0, 1 ) );
			AddMovementCapability( MovementCapability( 0,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, 0, 1 ) );
			AddMovementCapability( MovementCapability( 0, -1, 1 ) );
		}

		baseValue = 4500;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static KnightWazir knightWazir;
};

class KnightFerz:
	public PieceType64
{
public:
	//	construction
	KnightFerz():
		PieceType64( "Knight Ferz", "Knight Ferz", "N", 8, 8 )
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnightFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnightFerz.bmp";
			AddMovementCapability( MovementCapability( -1, 2, 1 ) );
			AddMovementCapability( MovementCapability( 1, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability( 1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 1, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( 1, -1, 1 ) );
		}

		baseValue = 4500;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static KnightFerz knightFerz;
};

class KnightDabbabah:
	public PieceType64
{
public:
	//	construction
	KnightDabbabah():
		PieceType64( "Knight Dabbabah", "Knight Dabbabah", "N", 8, 8 )
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WHorse.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BHorse.bmp";
			AddMovementCapability( MovementCapability( -1, 2, 1 ) );
			AddMovementCapability( MovementCapability( 1, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability( 1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 0, 1 ) );
			AddMovementCapability( MovementCapability( 0, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 0, 1 ) );
			AddMovementCapability( MovementCapability( 0, -2, 1 ) );
		}

		baseValue = 4500;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static KnightDabbabah knightDabbabah;
};

class KnightAlfil:	
	public PieceType64
{
public:
	//	construction
	KnightAlfil():
		PieceType64( "Knight Alfil", "Knight Alfil", "N", 8, 8 )
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WZebra.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BZebra.bmp";
			AddMovementCapability( MovementCapability( -1, 2, 1 ) );
			AddMovementCapability( MovementCapability( 1, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability( 1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
			AddMovementCapability( MovementCapability( 2, -2, 1 ) );
		}

		baseValue = 4500;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static KnightAlfil knightAlfil;
};

class EnepKnight:
	public PieceType64
{
public:
	//	construction
	EnepKnight() :
		PieceType64( "Enep Knight", "Enep Knight", "A", 8, 8 )
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnightWazir.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnightWazir.bmp";
			AddMovementCapability( MovementCapability( -1, 2, 1 ) );
			AddMovementCapability( MovementCapability( 1, 2, 1 ) );
			AddMovementCapability( MovementCapability( -2, 1, 1 ) );
			AddMovementCapability( MovementCapability( 2, 1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability( 1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 2, -1, 1 ) );
			AddMovementCapability( MovementCapability( 1, 0, 1, MoveOnly ) );
			AddMovementCapability( MovementCapability( 0, 1, 1, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1, 0, 1, MoveOnly ) );
			AddMovementCapability( MovementCapability( 0, -1, 1, MoveOnly ) );
		}

		baseValue = 3750;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
		armyAdjustment = 0;
		optimization = SimpleSingleStep;
	}

	static EnepKnight enepKnight;
};


#endif
