
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/



#include "StdAfx.h"
#include "Chess_Data.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


int openingPawnSquareBonuses[] = 
{   
  -20, -20, -20, -20, -20, -20, -20, -20, 
   20,  20, -20, -90,-100, -20,  20,  20, 
  -40, -40,  30,  60,  60,  30, -40, -40, 
  -40, -20,  40, 250, 250,  40, -20, -40, 
    0,   0,  60, 160, 160,  60,   0,   0, 
    0,   0,  60, 160, 160,  60,   0,   0, 
    0,   0,  60, 160, 160,  60,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0  
};

int openingPawnSquareBonuses_CD[] = 
{   
  -20, -20, -20, -20, -20, -20, -20, -20, 
   20,  20, -20, -90,-100, -20,  20,  20, 
  -50, -50,  30,  60,  60,  30, -50, -50, 
  -50, -50, 100, 300, 300, 100, -50, -50, 
    0,   0,  60, 200, 200,  60,   0,   0, 
    0,   0,  60, 160, 160,  60,   0,   0, 
    0,   0,  60, 160, 160,  60,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0  
};

int pawnSquareBonuses[] = 
{   
  -20, -20,   0,   0,   0,   0, -20, -20, 
   20,  20,  20, -20, -20,  20,  20,  20, 
   20,  20,  40,  60,  60,  40,  20,  20, 
   30,  60, 100, 200, 200, 100,  60,  30, 
   90, 100, 120, 300, 300, 120, 100,  90, 
  140, 180, 200, 320, 320, 200, 180, 140, 
  200, 200, 260, 340, 340, 160, 200, 200, 
    0,   0,   0,   0,   0,   0,   0,   0  
};

int endgamePawnSquareBonuses[] = 
{   
    0,   0,   0,   0,   0,   0,   0,   0, 
    0,   0,   0,   0,   0,   0,   0,   0, 
    0,   0,   0,  20,  20,   0,   0,   0, 
   30,  80,  90, 100, 100,  90,  80,  30, 
   60, 120, 140, 180, 180, 140, 120,  60, 
   90, 160, 190, 250, 250, 190, 160,  90, 
  140, 200, 250, 300, 300, 250, 200, 140, 
    0,   0,   0,   0,   0,   0,   0,   0  
};

int bishopSquareBonuses[] = 
{
	-116, -156, -182, -188, -188, -182, -156, -116,
	-80, -12, -38, -52, -52, -38, -12, -80,
	-112, -44, 38, 24, 24, 38, -44, -112,
	-124, -64, 18, 104, 104, 18, -64, -124,
	-124, -64, 18, 104, 104, 18, -64, -124,
	-112, -44, 38, 24, 24, 38, -44, -112,
	-80, -12, -38, -52, -52, -38, -12, -80,
	-36, -76, -102, -108, -108, -102, -76, -36
};

int knightSquareBonuses[] = 
{
	-160, 20, 220, 360, 360, 220, 20, -160,
	-620, -440, -120, 20, 20, -120, -440, -620,
	-480, -180, 140, 300, 300, 140, -180, -480,
	-400, -100, 240, 400, 400, 240, -100, -400,
	-420, -120, 220, 380, 380, 220, -120, -420,
	-540, -240, 80, 240, 240, 80, -240, -540,
	-720, -540, -220, -80, -80, -220, -540, -720,
	-860, -680, -480, -340, -340, -480, -680, -860
};

int queenSquareBonuses[] =
{
	-101, -63, -17, 13, 13, -17, -63, -101,
	-109, -29, 17, 49, 49, 17, -29, -109,
	-87, -7, 75, 107, 107, 75, -7, -87,
	-81, 1, 83, 157, 157, 83, 1, -81,
	-80, 2, 84, 158, 158, 84, 2, -80,
	-84, -4, 78, 110, 110, 78, -4, -84,
	-104, -24, 22, 54, 54, 22, -24, -104,
	-126, -88, -42, -12, -12, -42, -88, -126
};

int rookSquareBonuses[] = 
{
	-132, -56,   0,  26,  26,   0, -56, -132,
	 -92, -36,  20,  46,  46,  20, -36,  -92,
	 -60,  -4,  36,  62,  62,  36,  -4,  -60,
	 -58,  -2,  38,  62,  62,  38,  -2,  -58,
	 -57,  -1,  39,  63,  63,  39,  -1,  -57,
	 -57,  -1,  39,  65,  65,  39,  -1,  -57,
	 -87, -31,  25,  51,  51,  25, -31,  -87,
	-147, -71, -15,  11,  11, -15, -71, -147
};

int kingSquareBonuses[] =
{
   240, 240, 240, 160, 160,   0, 320, 320,
   240, 200, 160, 120, 120, 160, 200, 240,
   160, 120,  80,  40,  40,  80, 120, 160,
   120,  80,  40,   0,   0,  40,  80, 120,
    60,   0,   0,   0,   0,   0,   0,  60,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0
};

int endgameKingSquareBonuses[] =
{
    0,  60, 120, 180, 180, 120,  60,   0,
   60, 120, 180, 240, 240, 180, 120,  60,
  120, 180, 240, 320, 320, 240, 180, 120,
  180, 240, 320, 480, 480, 320, 240, 180,
  180, 240, 320, 480, 480, 320, 240, 180,
  120, 180, 240, 320, 320, 240, 180, 120,
   60, 120, 180, 240, 240, 180, 120,  60,
    0,  60, 120, 180, 180, 120,  60,   0
};

int ferzSquareBonuses[] = 
{
	15, 30, 57, 66, 66, 57, 30, 15,
	-96, -63, -36, -18, -18, -36, -63, -96,
	-78, -45, 9, 27, 27, 9, -45, -78,
	-78, -36, 18, 45, 45, 18, -36, -78,
	-69, -27, 27, 54, 54, 27, -27, -69,
	-51, -18, 36, 54, 54, 36, -18, -51,
	-51, -18, 9, 27, 27, 9, -18, -51,
	-60, -45, -18, -9, -9, -18, -45, -60
};

int waffleSquareBonuses[] = 
{
	-100, 80, 240, 340, 340, 240, 80, -100,
	-560, -360, -120, -40, -40, -120, -360, -560,
	-460, -180, 160, 300, 300, 160, -180, -460,
	-420, -160, 240, 400, 400, 240, -160, -420,
	-440, -180, 220, 380, 380, 220, -180, -440,
	-520, -240, 100, 240, 240, 100, -240, -520,
	-560, -460, -220, -140, -140, -220, -460, -660,
	-800, -620, -460, -360, -360, -460, -620, -800
};

int fadSquareBonuses[] = 
{
	-136, -108, -32, -32, -32, -32, -108, -136,
	-300, -172, -96, -56, -56, -96, -172, -300,
	-212, -84, 76, 116, 116, 76, -84, -212,
	-200, -32, 128, 132, 132, 128, -32, -200,
	-200, -32, 128, 132, 132, 128, -32, -200,
	-212, -84, 76, 116, 116, 76, -84, -212,
	-276, -172, -96, -56, -56, -96, -172, -300,
	-336, -308, -232, -232, -232, -232, -308, -336
};

int bedeSquareBonuses[] =
{
	-36, -42, -38, -42, -42, -38, -42, -36,
	-76, -26, -22, -6, -6, -22, -26, -76,
	-78, -28, 22, 38, 38, 22, -28, -78,
	-88, -18, 32, 74, 74, 32, -18, -88,
	-93, -23, 27, 69, 69, 27, -23, -93,
	-93, -43, 7, 23, 23, 7, -43, -93,
	-101, -51, -47, -31, -31, -47, -51, -101,
	-91, -97, -93, -97, -97, -93, -97, -91
};

int archbishopSquareBonuses[] = 
{
	8, -11, -36, -29, -29, -36, -11, 8,
	-48, 18, 23, 17, 17, 23, 18, -48,
	-76, 20, 99, 72, 72, 99, 20, -76,
	-72, 11, 69, 103, 103, 69, 11, -72,
	-75, 8, 66, 100, 100, 66, 8, -75,
	-85, 11, 90, 63, 63, 90, 11, -85,
	-63, 3, 8, 2, 2, 8, 3, -63,
	-42, -61, -86, -79, -79, -86, -61, -42
};

int chancellorSquareBonuses[] =
{
	-122, -78, -14, 50, 50, -14, -78, -122,
	-102, -62, 14, 78, 78, 14, -62, -102,
	-74, -22, 42, 98, 98, 42, -22, -74,
	-46, 6, 62, 98, 98, 62, 6, -46,
	-43, 9, 65, 101, 101, 65, 9, -43,
	-65, -13, 51, 107, 107, 51, -13, -65,
	-87, -47, 29, 93, 93, 29, -47, -87,
	-107, -63, 1, 65, 65, 1, -63, -107
};

int shortRookSquareBonuses[] = 
{
	-126, -68, -12, 22, 22, -12, -68, -126,
	-104, -46, 30, 74, 74, 30, -46, -104,
	-72, 6, 62, 96, 96, 62, 6, -72,
	-62, 26, 72, 98, 98, 72, 26, -62,
	-61, 27, 73, 99, 99, 73, 27, -61,
	-69, 9, 65, 99, 99, 65, 9, -69,
	-99, -41, 35, 79, 79, 35, -41, -99,
	-141, -83, -27, 7, 7, -27, -83, -141
};

int woodyRookSquareBonuses[] = 
{
	-210, -100, 0, 30, 30, 0, -100, -210,
	-300, -190, -50, 10, 10, -50, -190, -300,
	-230, -80, 60, 150, 150, 60, -80, -230,
	-230, -50, 120, 190, 190, 120, -50, -230,
	-240, -60, 110, 180, 180, 110, -60, -240,
	-260, -110, 30, 120, 120, 30, -110, -260,
	-350, -240, -100, -40, -40, -100, -240, -350,
	-440, -330, -230, -200, -200, -230, -330, -440
};

int halfDuckSquareBonuses[] = 
{
	-152, -112, -32, 28, 28, -32, -112, -152,
	-304, -212, -132, 16, 16, -132, -212, -304,
	-212, -120, 44, 116, 116, 44, -120, -212,
	-140, 40, 128, 108, 108, 128, 40, -140,
	-136, 44, 132, 112, 112, 132, 44, -136,
	-200, -108, 56, 128, 128, 56, -108, -200,
	-284, -192, -112, 36, 36, -112, -192, -284,
	-332, -292, -212, -152, -152, -212, -292, -332
};

int genericSmallCenterBonuses[] =
{
   -30,  -30, -30, -30, -30, -30,  -30,  -30,
   -30,    0,   0,   0,   0,   0,    0,  -30,
   -30,    0,  30,  30,  30,  30,    0,  -30,
   -30,    0,  30,  60,  60,  30,    0,  -30,
   -30,    0,  30,  60,  60,  30,    0,  -30,
   -30,    0,  30,  30,  30,  30,    0,  -30,
   -30,    0,   0,   0,   0,   0,    0,  -30,
   -80,  -60, -60, -60, -60, -60,  -60,  -80
};

int genericLargeCenterBonuses[] =
{
   -90,  -70, -70, -70, -70, -70,  -70,  -90,
   -70,    0,   0,   0,   0,   0,    0,  -70,
   -70,    0,  30,  60,  60,  30,    0,  -70,
   -70,    0,  60, 160, 160,  60,    0,  -70,
   -70,    0,  70, 160, 160,  70,    0,  -70,
   -70,    0,  50,  90,  90,  50,    0,  -70,
   -70,    0,  15,  15,  15,  15,    0,  -70,
   -90,  -70, -70, -70, -70, -70,  -70,  -90
};

int longLeaperSquareBonuses[] =
{
   -70,  -80, -50, -10, -10, -50,  -80,  -70,
   -80,   10, -10,  25,  25, -10,   10,  -80,
   -60,  -10,  30,  50,  50,  30,  -10,  -60,
   -40,   20,  50,  70,  70,  50,   20,  -40,
   -40,   20,  50,  70,  70,  50,   20,  -40,
   -60,  -10,  30,  50,  50,  30,  -10,  -60,
   -80,   10, -10,  25,  25, -10,   10,  -80,
   -70,  -80, -50, -10, -10, -50,  -80,  -70
};

int chameleonSquareBonuses[] =
{
 -100, -50, -50, -10, -10, -50, -50,-100,
  -50,   0, -10,  20,  20, -10,   0, -50,
  -30, -10,   0,  25,  25,   0, -10, -30,
    0,  10,  25,  45,  45,  25,  10,   0,
    0,  10,  25,  45,  45,  25,  10,   0,
  -30, -10,   0,  25,  50,   0, -10, -30,
  -50,   0, -10,  20,  20, -10,   0, -50,
 -100, -50, -50, -10, -10, -50, -50,-100 
};

int ultimaKingSquareBonuses[] = 
{
   80,  60,  60,  40,  40,  60,  60,  80,
   60,   0,   0,   0,   0,   0,   0,  60,
   60,   0,   0,   0,   0,   0,   0,  60,
   60,   0,   0,   0,   0,   0,   0,  60,
   60,   0,   0,   0,   0,   0,   0,  60,
   60,   0,   0,   0,   0,   0,   0,  60,
   60,   0,   0,   0,   0,   0,   0,  60,
   80,  60,  60,  40,  40,  60,  60,  80 
};

int openingUltimaPawnBonuses[] = 
{
    0,   0,   0,   0,   0,   0,   0,   0,
  -10, -20, -30, -30, -30, -30, -20, -10,
   10,  10,  10,  10,  10,  10,  10,  10,
   25,  25,  25,  25,  25,  25,  25,  25,
   60,  80,  80,  80,  80,  80,  80,  60,
   20,  20,  20,  20,  20,  20,  20,  20,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0 
};

int openingMajorPieceSquareBonuses[] =
{
     0,    0,   0,   0,   0,   0,    0,    0,
  -300, -300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300, -300, -300,
  -300, -300,-300,-300,-300,-300, -300, -300
};


//	values for posted pieces...
//	IMPORTANT: don't put non-zero values
//	on the left-most or right-most files!
//	the outpost code checks for pawns to
//	the left and right, and it doesn't 
//	check to make sure that's not off the
//	edge of the board!
//	you wouldn't want an outpost on the
//	rim anyway; it's not worth a bonus
int outpost[] = 
{
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   3,   6,  12,  12,   6,   3,   0,
    0,   4,   7,  15,  15,   7,   4,   0,
    0,   0,   7,  15,  15,   7,   0,   0,
    0,   0,   2,   5,   5,   2,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0 
};

//	zero matrix
int zeroes[] = 
{
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0 
};
